package com.ejianc.business.itax.service.impl;

import com.ejianc.business.itax.bean.SalaryCollectDetailEntity;
import com.ejianc.business.itax.service.ISalaryCollectDetailService;
import com.ejianc.business.itax.service.ISalaryDetailService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.itax.mapper.SalaryCollectMapper;
import com.ejianc.business.itax.bean.SalaryCollectEntity;
import com.ejianc.business.itax.service.ISalaryCollectService;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;

/**
 * 工人工资汇总
 * 
 * @author generator
 * 
 */
@Service("salaryCollectService")
public class SalaryCollectServiceImpl extends BaseServiceImpl<SalaryCollectMapper, SalaryCollectEntity> implements ISalaryCollectService{

    @Autowired
    private ISalaryDetailService salaryDetailService;
    @Autowired
    private ISalaryCollectDetailService collectDetailService;

    @Override
    public SalaryCollectEntity calculateCollectItax(SalaryCollectEntity salaryEntity) {

        Date billTime = salaryEntity.getBillTime();
        List<SalaryCollectDetailEntity> salaryCollectDetailEntities = baseMapper.calculateCollectItax(billTime);
        if (CollectionUtils.isNotEmpty(salaryCollectDetailEntities)){
            for (SalaryCollectDetailEntity salaryCollectDetailEntity : salaryCollectDetailEntities) {
                salaryCollectDetailEntity.setPid(salaryEntity.getId());
                // thisMonthIncomeItax  本月应纳税所得额---本年已申报+今年未申报+本月累计办理代发 - 累计减除 - 专项附加扣除  ，小于0为0
                // thisMonthItax  应缴个税----总应缴税额*公式
                BigDecimal bigDecimal = salaryCollectDetailEntity.getThisYearIncome()
                        .add(salaryCollectDetailEntity.getLastMonthWsbIncome())
                        .add(salaryCollectDetailEntity.getThisMonthDlffje())
                        .subtract(salaryCollectDetailEntity.getExpenseReduction())
                        .subtract(salaryCollectDetailEntity.getSpecialDeduction()).setScale(4, RoundingMode.HALF_UP);
                if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    salaryCollectDetailEntity.setThisMonthIncomeItax(bigDecimal);
                    salaryCollectDetailEntity.setThisMonthItax(salaryDetailService.calculate(bigDecimal));
                }else {
                    salaryCollectDetailEntity.setThisMonthIncomeItax(BigDecimal.ZERO);
                    salaryCollectDetailEntity.setThisMonthItax(BigDecimal.ZERO);
                }
            }

            collectDetailService.saveOrUpdateBatch(salaryCollectDetailEntities);
        }

        return salaryEntity;
    }
}
