/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.itax.service.impl;

import com.ejianc.business.itax.bean.SalaryCollectDetailEntity;
import com.ejianc.business.itax.bean.SalaryCollectEntity;
import com.ejianc.business.itax.mapper.SalaryCollectMapper;
import com.ejianc.business.itax.service.ISalaryCollectDetailService;
import com.ejianc.business.itax.service.ISalaryCollectService;
import com.ejianc.business.itax.service.ISalaryDetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="salaryCollectService")
public class SalaryCollectServiceImpl
extends BaseServiceImpl<SalaryCollectMapper, SalaryCollectEntity>
implements ISalaryCollectService {
    @Autowired
    private ISalaryDetailService salaryDetailService;
    @Autowired
    private ISalaryCollectDetailService collectDetailService;

    @Override
    public SalaryCollectEntity calculateCollectItax(SalaryCollectEntity salaryEntity) {
        Date billTime = salaryEntity.getBillTime();
        List<SalaryCollectDetailEntity> salaryCollectDetailEntities = ((SalaryCollectMapper)this.baseMapper).calculateCollectItax(billTime);
        if (CollectionUtils.isNotEmpty(salaryCollectDetailEntities)) {
            for (SalaryCollectDetailEntity salaryCollectDetailEntity : salaryCollectDetailEntities) {
                salaryCollectDetailEntity.setPid(salaryEntity.getId());
                BigDecimal bigDecimal = salaryCollectDetailEntity.getThisYearIncome().add(salaryCollectDetailEntity.getLastMonthWsbIncome()).add(salaryCollectDetailEntity.getThisMonthDlffje()).subtract(salaryCollectDetailEntity.getExpenseReduction()).subtract(salaryCollectDetailEntity.getSpecialDeduction()).setScale(4, RoundingMode.HALF_UP);
                if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    salaryCollectDetailEntity.setThisMonthIncomeItax(bigDecimal);
                    salaryCollectDetailEntity.setThisMonthItax(this.salaryDetailService.calculate(bigDecimal));
                    continue;
                }
                salaryCollectDetailEntity.setThisMonthIncomeItax(BigDecimal.ZERO);
                salaryCollectDetailEntity.setThisMonthItax(BigDecimal.ZERO);
            }
            this.collectDetailService.saveOrUpdateBatch(salaryCollectDetailEntities);
        }
        return salaryEntity;
    }
}

