/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.itax.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.itax.bean.SalaryDetailEntity;
import com.ejianc.business.itax.bean.SalaryEntity;
import com.ejianc.business.itax.bean.WorkerEntity;
import com.ejianc.business.itax.mapper.SalaryDetailMapper;
import com.ejianc.business.itax.service.ISalaryDetailService;
import com.ejianc.business.itax.service.ISalaryService;
import com.ejianc.business.itax.service.IWorkerService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="salaryDetailService")
public class SalaryDetailServiceImpl
extends BaseServiceImpl<SalaryDetailMapper, SalaryDetailEntity>
implements ISalaryDetailService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWorkerService workerService;
    @Autowired
    private ISalaryService salaryService;

    @Override
    public SalaryEntity calculateItax(SalaryEntity salaryEntity) {
        List<SalaryDetailEntity> detailList = salaryEntity.getSalaryDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List idCardList = detailList.stream().map(SalaryDetailEntity::getIdNum).collect(Collectors.toList());
            this.logger.info("\u4eba\u5458\u8eab\u4efd\u8bc1\u53f7m: {}", (Object)JSONObject.toJSONString(idCardList));
            Map<Object, Object> map = new HashMap();
            LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
            lambdaQueryWrapper1.eq(WorkerEntity::getState, (Object)1);
            lambdaQueryWrapper1.in(WorkerEntity::getIdNum, idCardList);
            lambdaQueryWrapper1.isNotNull(WorkerEntity::getIdNum);
            List rosterEntityList = this.workerService.list((Wrapper)lambdaQueryWrapper1);
            map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdNum(), Function.identity()));
            BigDecimal fiveThousand = new BigDecimal(5000);
            for (SalaryDetailEntity salaryDetailEntity : detailList) {
                WorkerEntity workerEntity = null;
                if (map.containsKey(salaryDetailEntity.getIdNum())) {
                    workerEntity = (WorkerEntity)((Object)map.get(salaryDetailEntity.getIdNum()));
                }
                if (salaryDetailEntity.getLastMonthState() == null) {
                    salaryDetailEntity.setLastMonthState("\u672a\u7533\u62a5");
                }
                if (salaryDetailEntity.getSalaryPayState() == null) {
                    salaryDetailEntity.setSalaryPayState("\u672a\u53d1\u653e");
                }
                BigDecimal thisYearIncome = BigDecimal.ZERO;
                if (workerEntity != null) {
                    int month = DateUtil.month((Date)workerEntity.getEffectiveStartTime()) + 1;
                    int year = DateUtil.year((Date)workerEntity.getEffectiveStartTime());
                    int yearNow = DateUtil.year((Date)new Date());
                    if (yearNow > year) {
                        salaryDetailEntity.setMonthNum(1);
                    } else {
                        salaryDetailEntity.setMonthNum(month);
                        thisYearIncome = ((SalaryDetailMapper)this.baseMapper).thisYearWorkerRegistMny(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum());
                    }
                } else {
                    salaryDetailEntity.setMonthNum(DateUtil.month((Date)salaryEntity.getBillTime()) == 0 ? 1 : DateUtil.month((Date)salaryEntity.getBillTime()));
                }
                salaryDetailEntity.setThisYearIncome(thisYearIncome);
                salaryDetailEntity.setThisMonthNum(((SalaryDetailMapper)this.baseMapper).thisMonthWorkerRegistNum(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum()));
                salaryDetailEntity.setThisMonthDlffje(((SalaryDetailMapper)this.baseMapper).thisMonthWorkerRegistMny(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum()).setScale(4, RoundingMode.HALF_UP));
                salaryDetailEntity.setExpenseReduction(new BigDecimal(DateUtil.month((Date)salaryEntity.getBillTime()) - salaryDetailEntity.getMonthNum() + 2).multiply(fiveThousand).setScale(4, RoundingMode.HALF_UP));
                salaryDetailEntity.setThisYearItax(((SalaryDetailMapper)this.baseMapper).thisYearWorkerRegistMny(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum()));
                salaryDetailEntity.setSpecialDeduction(BigDecimal.ZERO);
                salaryDetailEntity.setLastMonthWsbItax(null);
                salaryDetailEntity.setLastMonthWsbIncome(((SalaryDetailMapper)this.baseMapper).thisYearWorkerNoRegistMny(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum()));
                salaryDetailEntity.setThisMonthPrepayItax(((SalaryDetailMapper)this.baseMapper).thisMonthWorkerItaxMny(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum()));
                BigDecimal bigDecimal = salaryDetailEntity.getThisYearIncome().add(salaryDetailEntity.getLastMonthWsbIncome()).add(salaryDetailEntity.getThisMonthDlffje()).subtract(salaryDetailEntity.getExpenseReduction()).subtract(salaryDetailEntity.getSpecialDeduction()).setScale(4, RoundingMode.HALF_UP);
                if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    salaryDetailEntity.setThisMonthIncomeItax(bigDecimal);
                    salaryDetailEntity.setThisMonthItax(this.calculate(bigDecimal).subtract(salaryDetailEntity.getThisMonthPrepayItax()).setScale(4, RoundingMode.HALF_UP));
                } else {
                    salaryDetailEntity.setThisMonthIncomeItax(BigDecimal.ZERO);
                    salaryDetailEntity.setThisMonthItax(BigDecimal.ZERO);
                }
                salaryDetailEntity.setThisMonthItaxYj(BigDecimal.ZERO);
            }
            this.updateBatchById(detailList);
        }
        return salaryEntity;
    }

    @Override
    public BigDecimal calculate(BigDecimal mny) {
        BigDecimal bigDecimal = new BigDecimal(0);
        if (mny.compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException("\u91d1\u989d\u8ba1\u7b97\u9519\u8bef\uff01" + mny);
        }
        bigDecimal = mny.compareTo(new BigDecimal(36000)) <= 0 ? mny.multiply(new BigDecimal(0.03)).setScale(4, RoundingMode.HALF_UP) : (mny.compareTo(new BigDecimal(144000)) <= 0 ? mny.multiply(new BigDecimal(0.1)).subtract(new BigDecimal(2520)).setScale(4, RoundingMode.HALF_UP) : (mny.compareTo(new BigDecimal(300000)) <= 0 ? mny.multiply(new BigDecimal(0.2)).subtract(new BigDecimal(16920)).setScale(4, RoundingMode.HALF_UP) : (mny.compareTo(new BigDecimal(420000)) <= 0 ? mny.multiply(new BigDecimal(0.25)).subtract(new BigDecimal(31920)).setScale(4, RoundingMode.HALF_UP) : (mny.compareTo(new BigDecimal(660000)) <= 0 ? mny.multiply(new BigDecimal(0.3)).subtract(new BigDecimal(52920)).setScale(4, RoundingMode.HALF_UP) : (mny.compareTo(new BigDecimal(960000)) <= 0 ? mny.multiply(new BigDecimal(0.35)).subtract(new BigDecimal(85920)).setScale(4, RoundingMode.HALF_UP) : mny.multiply(new BigDecimal(0.45)).subtract(new BigDecimal(181920)).setScale(4, RoundingMode.HALF_UP))))));
        return bigDecimal;
    }

    public static void main(String[] args) {
    }
}

