/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.itax.utils;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class DetailIndexExcelReaderZzyj {
    public static List<List<String>> readExcel(MultipartFile file) {
        String originalFileName = file.getOriginalFilename();
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
        extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
        if ("xls".equals(extName)) {
            return DetailIndexExcelReaderZzyj.read2003Excel(file);
        }
        if ("xlsx".equals(extName)) {
            return DetailIndexExcelReaderZzyj.read2007Excel(file);
        }
        throw new BusinessException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
    }

    /*
     * WARNING - void declaration
     */
    private static List<List<String>> read2003Excel(MultipartFile file) {
        HSSFWorkbook hwb;
        LinkedList<List<String>> list = new LinkedList<List<String>>();
        try {
            hwb = new HSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
        }
        catch (IOException var18) {
            throw new BusinessException(var18.getMessage());
        }
        int size = hwb.getNumberOfSheets();
        block9: for (int index = 0; index < size; ++index) {
            HSSFSheet sheet = hwb.getSheetAt(index);
            String value = null;
            HSSFRow row = null;
            HSSFCell cell = null;
            boolean isEmpty = true;
            int rowFirstCellNum = 0;
            for (int i = sheet.getFirstRowNum() + 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                int headLength;
                isEmpty = true;
                row = sheet.getRow(i);
                if (row == null) continue;
                int rowLastCellNum = sheet.getRow(0).getLastCellNum();
                LinkedList<String> linked = new LinkedList<String>();
                for (headLength = rowFirstCellNum; headLength < rowLastCellNum; ++headLength) {
                    cell = row.getCell(headLength);
                    if (cell == null) {
                        linked.add("");
                        continue;
                    }
                    switch (cell.getCellType()) {
                        case 0: {
                            cell.setCellType(1);
                            value = cell.getStringCellValue();
                            break;
                        }
                        case 1: {
                            value = cell.getStringCellValue().toString();
                            break;
                        }
                        case 2: {
                            HSSFFormulaEvaluator evaluator = new HSSFFormulaEvaluator(hwb);
                            CellValue cellValue = evaluator.evaluate((Cell)cell);
                            int actualType = cellValue.getCellType();
                            if (actualType == 4) {
                                value = cellValue.getBooleanValue() + "";
                                break;
                            }
                            if (actualType == 0) {
                                cell.setCellType(1);
                                value = cell.getStringCellValue();
                                break;
                            }
                            if (actualType != 1) break;
                            value = cellValue.getStringValue();
                            break;
                        }
                        case 3: {
                            value = "";
                            break;
                        }
                        case 4: {
                            value = " " + cell.getBooleanCellValue();
                            break;
                        }
                        default: {
                            value = "Error";
                        }
                    }
                    linked.add(value);
                }
                if (list.size() > 0) {
                    headLength = list.get(0).size();
                    int nowLinkLength = linked.size();
                    if (nowLinkLength < headLength) {
                        void var16_21;
                        int n = nowLinkLength;
                        while (var16_21 < headLength) {
                            linked.add(null);
                            ++var16_21;
                        }
                    }
                }
                if (isEmpty) {
                    for (Object e : linked) {
                        if (e == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(e))) continue;
                        isEmpty = false;
                        break;
                    }
                }
                if (isEmpty) continue block9;
                list.add(linked);
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static List<List<String>> read2007Excel(MultipartFile file) {
        XSSFWorkbook xwb;
        LinkedList<List<String>> list = new LinkedList<List<String>>();
        try {
            xwb = new XSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
        }
        catch (IOException var18) {
            throw new BusinessException(var18.getMessage());
        }
        int size = xwb.getNumberOfSheets();
        block9: for (int index = 0; index < size; ++index) {
            XSSFSheet sheet = xwb.getSheetAt(index);
            String value = null;
            XSSFRow row = null;
            XSSFCell cell = null;
            boolean isEmpty = true;
            int rowFirstCellNum = 0;
            for (int i = sheet.getFirstRowNum() + 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                int headLength;
                isEmpty = true;
                row = sheet.getRow(i);
                int rowLastCellNum = sheet.getRow(0).getLastCellNum();
                if (row == null) continue;
                LinkedList<String> linked = new LinkedList<String>();
                for (headLength = rowFirstCellNum; headLength < rowLastCellNum; ++headLength) {
                    cell = row.getCell(headLength);
                    if (cell == null) {
                        linked.add("");
                        continue;
                    }
                    switch (cell.getCellType()) {
                        case 0: {
                            cell.setCellType(1);
                            value = cell.getStringCellValue();
                            break;
                        }
                        case 1: {
                            value = cell.getStringCellValue().toString();
                            break;
                        }
                        case 2: {
                            XSSFFormulaEvaluator evaluator = new XSSFFormulaEvaluator(xwb);
                            CellValue cellValue = evaluator.evaluate((Cell)cell);
                            int actualType = cellValue.getCellType();
                            if (actualType == 4) {
                                value = cellValue.getBooleanValue() + "";
                                break;
                            }
                            if (actualType == 0) {
                                cell.setCellType(1);
                                value = cell.getStringCellValue();
                                break;
                            }
                            if (actualType != 1) break;
                            value = cellValue.getStringValue();
                            break;
                        }
                        case 3: {
                            value = "";
                            break;
                        }
                        case 4: {
                            value = " " + cell.getBooleanCellValue();
                            break;
                        }
                        default: {
                            value = "Error";
                        }
                    }
                    linked.add(value);
                }
                if (list.size() > 0) {
                    headLength = list.get(0).size();
                    int nowLinkLength = linked.size();
                    if (nowLinkLength < headLength) {
                        void var16_21;
                        int n = nowLinkLength;
                        while (var16_21 < headLength) {
                            linked.add(null);
                            ++var16_21;
                        }
                    }
                }
                if (isEmpty) {
                    for (Object e : linked) {
                        if (e == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(e))) continue;
                        isEmpty = false;
                        break;
                    }
                }
                if (isEmpty) continue block9;
                list.add(linked);
            }
        }
        return list;
    }
}

