/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.laborservice.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractEntity;
import com.ejianc.business.laborservice.service.ILaborserviceIncomeContractService;
import com.ejianc.business.laborservice.service.ILaborserviceInvoiceApplyService;
import com.ejianc.business.laborservice.vo.LaborserviceIncomeContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"laborserviceIncomeContract"})
public class LaborserviceIncomeContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "\u52b3\u52a1-\u6536\u5165\u5408\u540c";
    @Autowired
    private ILaborserviceIncomeContractService service;
    @Autowired
    private ILaborserviceInvoiceApplyService applyService;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LaborserviceIncomeContractVO> saveOrUpdate(@RequestBody LaborserviceIncomeContractVO saveOrUpdateVO) {
        LaborserviceIncomeContractEntity entity = (LaborserviceIncomeContractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LaborserviceIncomeContractEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        LaborserviceIncomeContractVO vo = (LaborserviceIncomeContractVO)BeanMapper.map((Object)((Object)entity), LaborserviceIncomeContractVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LaborserviceIncomeContractVO> queryDetail(Long id) {
        LaborserviceIncomeContractEntity entity = (LaborserviceIncomeContractEntity)((Object)this.service.selectById(id));
        LaborserviceIncomeContractVO vo = (LaborserviceIncomeContractVO)BeanMapper.map((Object)((Object)entity), LaborserviceIncomeContractVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LaborserviceIncomeContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LaborserviceIncomeContractVO laborserviceIncomeContractVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LaborserviceIncomeContractVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplier");
        fuzzyFields.add("contractAccumulateTaxMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LaborserviceIncomeContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplier");
        fuzzyFields.add("contractAccumulateTaxMny");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        for (LaborserviceIncomeContractEntity laborserviceIncomeContractEntity : list) {
            if (laborserviceIncomeContractEntity.getIsSignExpendContract() == 1) {
                laborserviceIncomeContractEntity.setCreateUserName("\u662f");
                continue;
            }
            laborserviceIncomeContractEntity.setCreateUserName("\u5426");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborserviceIncomeContract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLaborIncomeContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LaborserviceIncomeContractVO>> refLaborserviceIncomeContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplier");
        fuzzyFields.add("firstPartyName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)).get((Object)"isSignExpendContract")) {
            param.getParams().put("isSignExpendContract", new Parameter("eq", (Object)_con.getString("isSignExpendContract")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LaborserviceIncomeContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"getUnionContractInfo"})
    @ResponseBody
    public CommonResponse<IPage<LaborserviceIncomeContractVO>> getUnionContractInfo(@RequestBody QueryParam param) {
        long projectId = Long.parseLong(((Parameter)param.getParams().get("projectId")).getValue().toString());
        String teamId = ((Parameter)param.getParams().get("supplierSignerId")).getValue().toString();
        List<LaborserviceIncomeContractVO> unionContractInfo = this.service.getUnionContractInfo(teamId, projectId);
        if (CollectionUtils.isNotEmpty(unionContractInfo)) {
            Page resp = new Page();
            resp.setRecords(unionContractInfo);
            resp.setTotal((long)unionContractInfo.size());
            resp.setSize((long)param.getPageSize());
            resp.setCurrent((long)param.getPageIndex());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
    }

    @GetMapping(value={"queryExpendDetail"})
    @ResponseBody
    public CommonResponse<LaborserviceIncomeContractVO> queryExpendDetail(Long id) {
        LaborserviceIncomeContractVO contractVO = this.service.queryExpendDetail(id);
        return CommonResponse.success((Object)contractVO);
    }

    @RequestMapping(value={"/refIncomeContractTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyFazdTree(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText) {
        List<LaborserviceIncomeContractVO> dataList = null;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
            }
            dataList = this.service.queryListTree(params);
            List maps = BeanMapper.mapList(dataList, Map.class);
            for (Map map : maps) {
                String name = map.get("contractName").toString();
                map.remove("contractName");
                map.put("name", name);
            }
            return ResultAsTree.createTreeData((List)maps);
        }
        catch (Exception e) {
            return null;
        }
    }

    @PostMapping(value={"listContractLedger"})
    @ResponseBody
    public CommonResponse<IPage<LaborserviceIncomeContractVO>> listContractLedger(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplier");
        fuzzyFields.add("projectManagerDept");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage<LaborserviceIncomeContractVO> pageData = this.service.listContractLedger(param);
        return CommonResponse.success(pageData);
    }
}

