/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.itax.service.impl;

import com.ejianc.business.itax.bean.SalaryDetailEntity;
import com.ejianc.business.itax.bean.SalaryEntity;
import com.ejianc.business.itax.mapper.SalaryMapper;
import com.ejianc.business.itax.service.ISalaryDetailService;
import com.ejianc.business.itax.service.ISalaryService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="salary")
public class SalaryBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ISalaryService service;
    @Autowired
    private ISalaryDetailService detailService;
    @Autowired
    private SalaryMapper mapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        List<String> stringList = this.mapper.idNumThanZero(billId);
        if (CollectionUtils.isNotEmpty(stringList)) {
            return CommonResponse.error((String)"\u5b50\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u7684id\uff0c\u8bf7\u6c47\u603b\u6216\u5220\u9664\u6570\u636e\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SalaryEntity salaryEntity = (SalaryEntity)((Object)this.service.selectById(billId));
        if (salaryEntity != null) {
            salaryEntity.setSubmitTime(new Date());
            this.service.saveOrUpdate((Object)salaryEntity);
            this.logger.info("\u8ba1\u7b97\u4e2a\u7a0e\u5f00\u59cb\uff1a{}", (Object)System.currentTimeMillis());
            this.detailService.calculateItax(salaryEntity);
            this.logger.info("\u8ba1\u7b97\u4e2a\u7a0e\u7ed3\u675f\uff1a{}", (Object)System.currentTimeMillis());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SalaryEntity salaryEntity = (SalaryEntity)((Object)this.service.selectById(billId));
        if (salaryEntity != null) {
            List<SalaryDetailEntity> salaryDetailList = salaryEntity.getSalaryDetailList();
            if (CollectionUtils.isNotEmpty(salaryDetailList)) {
                for (SalaryDetailEntity salaryDetailEntity : salaryDetailList) {
                    if (!"\u5df2\u53d1\u653e".equals(salaryDetailEntity.getSalaryPayState()) && "\u672a\u7533\u62a5".equals(salaryDetailEntity.getLastMonthState()) && salaryDetailEntity.getThisMonthItaxYj().compareTo(new BigDecimal(0)) == 0) continue;
                    return CommonResponse.error((String)"\u5b58\u5728\u5df2\u751f\u6548\u7684\u5de5\u8d44\u5355\uff01");
                }
            }
            salaryEntity.setSubmitTime(null);
            this.service.saveOrUpdate((Object)salaryEntity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

