/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.itax.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.itax.bean.SalaryCollectDetailEntity;
import com.ejianc.business.itax.bean.SalaryCollectEntity;
import com.ejianc.business.itax.bean.WorkerEntity;
import com.ejianc.business.itax.service.ISalaryCollectDetailService;
import com.ejianc.business.itax.service.ISalaryCollectService;
import com.ejianc.business.itax.vo.SalaryCollectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"salaryCollect"})
public class SalaryCollectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISalaryCollectDetailService detailService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISalaryCollectService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalaryCollectVO> saveOrUpdate(@RequestBody SalaryCollectVO saveOrUpdateVO) {
        SalaryCollectEntity entity = (SalaryCollectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SalaryCollectEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.service.calculateCollectItax(entity);
        SalaryCollectVO vo = (SalaryCollectVO)BeanMapper.map((Object)((Object)entity), SalaryCollectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalaryCollectVO> queryDetail(Long id) {
        SalaryCollectEntity entity = (SalaryCollectEntity)((Object)this.service.selectById(id));
        SalaryCollectVO vo = (SalaryCollectVO)BeanMapper.map((Object)((Object)entity), SalaryCollectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalaryCollectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SalaryCollectVO salaryCollectVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalaryCollectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalaryCollectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SalaryCollect-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSalaryCollectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalaryCollectVO>> refSalaryCollectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalaryCollectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getWsb3Month"}, method={RequestMethod.POST})
    @ResponseBody
    public void getWsb3Month(HttpServletRequest request, HttpServletResponse response, @RequestBody SalaryCollectEntity entity) {
        SalaryCollectEntity salaryCollectEntity = (SalaryCollectEntity)((Object)this.service.getById(entity.getId()));
        List<WorkerEntity> wsb3Month = this.service.getWsb3Month(salaryCollectEntity.getBillTime());
        List<WorkerEntity> wsbThisMonth = this.service.getWsbThisMonth(salaryCollectEntity.getBillTime());
        for (WorkerEntity workerEntity : wsb3Month) {
            workerEntity.setRemark("\u975e\u6b63\u5e38");
            workerEntity.setOrgName("\u5c45\u6c11\u8eab\u4efd\u8bc1");
            if (workerEntity.getEffectiveStartTime() == null) continue;
            workerEntity.setProjectName(DateUtil.format((Date)workerEntity.getEffectiveStartTime(), (String)"yyyy-MM-dd"));
        }
        for (WorkerEntity workerEntity : wsbThisMonth) {
            workerEntity.setRemark("\u975e\u6b63\u5e38");
            workerEntity.setOrgName("\u5c45\u6c11\u8eab\u4efd\u8bc1");
            if (workerEntity.getEffectiveStartTime() == null) continue;
            workerEntity.setProjectName(DateUtil.format((Date)workerEntity.getEffectiveStartTime(), (String)"yyyy-MM-dd"));
        }
        ArrayList<WorkerEntity> workerEntities = new ArrayList<WorkerEntity>();
        workerEntities.addAll(wsb3Month);
        workerEntities.addAll(wsbThisMonth);
        LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
        lambdaQueryWrapper1.eq(SalaryCollectDetailEntity::getPid, (Object)entity.getId());
        lambdaQueryWrapper1.eq(SalaryCollectDetailEntity::getUserState, (Object)2);
        lambdaQueryWrapper1.eq(BaseEntity::getDr, (Object)0);
        List rosterEntityList = this.detailService.list((Wrapper)lambdaQueryWrapper1);
        List workerEntities1 = BeanMapper.mapList((Iterable)rosterEntityList, WorkerEntity.class);
        for (WorkerEntity salaryCollectDetailEntity : workerEntities1) {
            int i1 = Integer.parseInt(salaryCollectDetailEntity.getIdNum().substring(16, 17));
            if (i1 % 2 == 0) {
                salaryCollectDetailEntity.setSex("\u5973");
            } else {
                salaryCollectDetailEntity.setSex("\u7537");
            }
            salaryCollectDetailEntity.setRemark("\u6b63\u5e38");
            salaryCollectDetailEntity.setOrgName("\u5c45\u6c11\u8eab\u4efd\u8bc1");
            if (salaryCollectDetailEntity.getEffectiveStartTime() == null) continue;
            salaryCollectDetailEntity.setProjectName(DateUtil.format((Date)salaryCollectDetailEntity.getEffectiveStartTime(), (String)"yyyy-MM-dd"));
        }
        workerEntities.addAll(workerEntities1);
        HashMap<String, ArrayList<WorkerEntity>> beans = new HashMap<String, ArrayList<WorkerEntity>>();
        beans.put("records", workerEntities);
        ExcelExport.getInstance().export("getWorkerList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/getUnregist"}, method={RequestMethod.POST})
    @ResponseBody
    public void getUnregist(HttpServletRequest request, HttpServletResponse response, @RequestBody SalaryCollectEntity entity) {
        LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
        lambdaQueryWrapper1.eq(SalaryCollectDetailEntity::getPid, (Object)entity.getId());
        lambdaQueryWrapper1.eq(SalaryCollectDetailEntity::getUserState, (Object)2);
        lambdaQueryWrapper1.eq(BaseEntity::getDr, (Object)0);
        List rosterEntityList = this.detailService.list((Wrapper)lambdaQueryWrapper1);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", rosterEntityList);
        ExcelExport.getInstance().export("getWsb3Month-export.xlsx", beans, response);
    }
}

