/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.itax.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.itax.bean.SalaryDetailEntity;
import com.ejianc.business.itax.bean.SalaryEntity;
import com.ejianc.business.itax.bean.WorkerEntity;
import com.ejianc.business.itax.service.ISalaryDetailService;
import com.ejianc.business.itax.service.ISalaryService;
import com.ejianc.business.itax.service.IWorkerService;
import com.ejianc.business.itax.utils.DetailIndexExcelReaderZzyj;
import com.ejianc.business.itax.utils.IdCardCheck;
import com.ejianc.business.itax.vo.SalaryDetailVO;
import com.ejianc.business.itax.vo.SalaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"salary"})
public class SalaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISalaryService service;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${ejc.roleid}")
    private Long roleId;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private ISalaryDetailService detailService;
    @Autowired
    private IWorkerService workerService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalaryVO> saveOrUpdate(@RequestBody SalaryVO saveOrUpdateVO) {
        SalaryEntity entity = (SalaryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SalaryEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setCreateUserName(userContextCache.getUserName());
            entity.setCreateUserId(userContextCache.getUserId());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        SalaryEntity salaryEntity1 = (SalaryEntity)((Object)this.service.selectById(entity.getId()));
        List<SalaryDetailEntity> salaryDetailList = salaryEntity1.getSalaryDetailList();
        BigDecimal kczl = salaryDetailList.stream().map(SalaryDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        salaryEntity1.setMoneySum(kczl);
        this.service.saveOrUpdate((Object)salaryEntity1);
        SalaryVO vo = (SalaryVO)BeanMapper.map((Object)((Object)salaryEntity1), SalaryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalaryVO> queryDetail(Long id) {
        SalaryEntity entity = (SalaryEntity)((Object)this.service.selectById(id));
        SalaryVO vo = (SalaryVO)BeanMapper.map((Object)((Object)entity), SalaryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalaryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SalaryVO salaryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("operatorName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean viewFlag = false;
        UserContext userContextCache = this.sessionManager.getUserContext();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        roleIds.add(this.roleId);
        CommonResponse roleResp = this.roleApi.getRoleUser(roleIds, null);
        if (!roleResp.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u53d1\u9001\u4fe1\u606f\u89d2\u8272\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List relationVOS = (List)roleResp.getData();
        List userIds = relationVOS.stream().map(RoleUserRelationVO::getUserId).map(Object::toString).collect(Collectors.toList());
        if (userIds.contains(userContextCache.getUserId().toString())) {
            viewFlag = true;
        }
        if (!viewFlag) {
            param.getParams().put("createUserId", new Parameter("eq", (Object)userContextCache.getUserId()));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Salary-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSalaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalaryVO>> refSalaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Salary-import.xlsx", (String)"\u5de5\u8d44\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response, Long id) throws ParseException {
        SalaryEntity salaryEntity = (SalaryEntity)((Object)this.service.selectById(id));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SalaryDetailVO> successList = new ArrayList<SalaryDetailVO>();
        ArrayList<SalaryDetailVO> errorList = new ArrayList<SalaryDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList<String> idCardList = new ArrayList<String>();
            for (int i = 1; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                idCardList.add(datas.get(0).trim());
            }
            LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
            lambdaQueryWrapper1.eq(WorkerEntity::getState, (Object)1);
            lambdaQueryWrapper1.in(WorkerEntity::getIdNum, idCardList);
            lambdaQueryWrapper1.isNotNull(WorkerEntity::getIdNum);
            List rosterEntityList = this.workerService.list((Wrapper)lambdaQueryWrapper1);
            Map userMap = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdNum(), Function.identity()));
            for (int i = 1; i < result.size(); ++i) {
                SalaryDetailVO detailVO;
                List<String> datas;
                block12: {
                    datas = result.get(i);
                    detailVO = new SalaryDetailVO();
                    detailVO.setOperatorName(salaryEntity.getOperatorName());
                    detailVO.setProjectName(salaryEntity.getProjectName());
                    detailVO.setOrgName(salaryEntity.getOrgName());
                    detailVO.setId(Long.valueOf(IdWorker.getId()));
                    if (StringUtils.isNotBlank((CharSequence)datas.get(0)) || StringUtils.isNotBlank((CharSequence)datas.get(1)) || StringUtils.isNotBlank((CharSequence)datas.get(3))) {
                        try {
                            String idCard = datas.get(0).trim();
                            detailVO.setIdNum(idCard);
                            String userName = datas.get(1).trim();
                            detailVO.setName(userName);
                            String money = datas.get(3);
                            detailVO.setMoney(StringUtils.isNotBlank((CharSequence)money) ? new BigDecimal(money) : null);
                            IdCardCheck idCardCheck = new IdCardCheck();
                            if (!idCardCheck.checkIdCardNum(idCard)) {
                                detailVO.setErrorMsg("\u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u9519\u8bef\uff01");
                                errorList.add(detailVO);
                            }
                            break block12;
                        }
                        catch (Exception e) {
                            detailVO.setErrorMsg("\u540d\u79f0\u3001\u8eab\u4efd\u8bc1\u53f7\u3001\u672c\u6b21\u53d1\u653e\u91d1\u989d\u9519\u8bef\uff01");
                            errorList.add(detailVO);
                        }
                        continue;
                    }
                    detailVO.setErrorMsg("\u540d\u79f0\u3001\u8eab\u4efd\u8bc1\u53f7\u3001\u672c\u6b21\u53d1\u653e\u91d1\u989d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                if (userMap.containsKey(detailVO.getIdNum())) {
                    if (!detailVO.getName().equals(((WorkerEntity)((Object)userMap.get(detailVO.getIdNum()))).getName())) {
                        detailVO.setErrorMsg("\u540d\u79f0\u3001\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5339\u914d\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setUserState(Integer.valueOf(1));
                    detailVO.setIsRegist("\u5df2\u767b\u8bb0");
                } else {
                    detailVO.setUserState(Integer.valueOf(2));
                    detailVO.setIsRegist("\u672a\u767b\u8bb0");
                }
                detailVO.setPhone(datas.get(2));
                detailVO.setRowState("add");
                successList.add(detailVO);
                SalaryDetailEntity map = (SalaryDetailEntity)((Object)BeanMapper.map((Object)detailVO, SalaryDetailEntity.class));
                map.setPid(id);
                map.setId(null);
                this.detailService.saveOrUpdate((Object)map);
            }
        }
        SalaryEntity salaryEntity1 = (SalaryEntity)((Object)this.service.selectById(id));
        List<SalaryDetailEntity> salaryDetailList = salaryEntity1.getSalaryDetailList();
        BigDecimal kczl = salaryDetailList.stream().map(SalaryDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        salaryEntity1.setMoneySum(kczl);
        this.service.saveOrUpdate((Object)salaryEntity1);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

