package com.ejianc.business.itax.mapper;

import com.ejianc.business.itax.bean.SalaryCollectDetailEntity;
import com.ejianc.business.itax.bean.WorkerEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.itax.bean.SalaryCollectEntity;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 工人工资汇总
 * 
 * @author generator
 * 
 */
@Mapper
public interface SalaryCollectMapper extends BaseCrudMapper<SalaryCollectEntity> {

    @Select("SELECT GROUP_CONCAT(pid Separator ',') salaryids,id_num,name,phone,sum(money) as money,month_num,user_state,GROUP_CONCAT(last_month_state Separator ',') last_month_state,count(*) as this_month_num,this_year_income,sum(money) as this_month_dlffje,expense_reduction,this_year_itax,special_deduction,last_month_wsb_itax,last_month_wsb_income \n" +
            "            from (\n" +
            "            SELECT * FROM `zzyj_laborservice_itax_salary_detail`\n" +
            "            where dr = 0 and salary_pay_state = '已发放'\n" +
            "            and pid in (\n" +
            "            SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "            where dr = 0 and bill_state in (1,3) and DATE_FORMAT(bill_time, '%Y%m') = DATE_FORMAT(#{billTime}, '%Y%m'))\n" +
            "            order by this_month_num desc\n" +
            "            ) a GROUP BY id_num ")
    List<SalaryCollectDetailEntity> calculateCollectItax(Date billTime);


    @Select("SELECT t.id_num,t.name,worker.phone,worker.sex,count(*) num FROM (\n" +
            "\n" +
            "SELECT id,id_num,name,COUNT(CASE WHEN last_month_state = '已申报' THEN 1 END) > 0 AS a  FROM `zzyj_laborservice_itax_salary_detail`\n" +
            "where dr = 0  and salary_pay_state = '已发放' \n" +
            "and pid in (SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "            where dr = 0 and bill_state in (1,3)\n" +
            "            and PERIOD_DIFF( date_format(#{billTime} , '%Y%m' ) , date_format(bill_time, '%Y%m' ) ) =0)\n" +
            "\t\t\t\t\t\tgroup by id_num  having a = 0\n" +
            "\t\t\t\t\t\t\n" +
            "\t\t\t\t\t\tUNION\n" +
            "\t\t\t\t\t\tSELECT id,id_num,name,COUNT(CASE WHEN last_month_state = '已申报' THEN 1 END) > 0 AS a  FROM `zzyj_laborservice_itax_salary_detail`\n" +
            "where dr = 0  and salary_pay_state = '已发放' \n" +
            "and pid in (SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "            where dr = 0 and bill_state in (1,3)\n" +
            "            and PERIOD_DIFF( date_format(#{billTime} , '%Y%m' ) , date_format(bill_time, '%Y%m' ) ) =1)\n" +
            "\t\t\t\t\t\tgroup by id_num  having a = 0\n" +
            "\n" +
            "\t\t\t\t\t\tUNION\n" +
            "\t\t\t\t\t\tSELECT id,id_num,name,COUNT(CASE WHEN last_month_state = '已申报' THEN 1 END) > 0 AS a  FROM `zzyj_laborservice_itax_salary_detail`\n" +
            "where dr = 0  and salary_pay_state = '已发放' \n" +
            "and pid in (SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "            where dr = 0 and bill_state in (1,3)\n" +
            "            and PERIOD_DIFF( date_format(#{billTime} , '%Y%m' ) , date_format(bill_time, '%Y%m' ) ) =2)\n" +
            "\t\t\t\t\t\tgroup by id_num  having a = 0\n" +
            ") as t LEFT JOIN zzyj_laborservice_itax_worker worker on worker.id_num = t.id_num\n" +
            "where worker.dr = 0\n" +
            "GROUP BY t.id_num having num >= 3  ")
    List<WorkerEntity> getWsb3Month(Date billTime);

    @Select("SELECT * FROM `zzyj_laborservice_itax_worker`\n" +
            "where dr = 0 and state = 1 and id_num not in (\n" +
            "SELECT id_num FROM `zzyj_laborservice_itax_salary_detail`\n" +
            "where dr = 0  and salary_pay_state = '已发放' \n" +
//            "-- and last_month_state in ('已申报','申报0')\n" +
            "and pid in (SELECT id FROM `zzyj_laborservice_itax_salary`\n" +
            "where dr = 0 and bill_state in (1,3)\n" +
            "and  date_format(bill_time, '%Y%m') =  DATE_FORMAT(#{billTime}, '%Y%m'))\n" +
            "group by id_num\n" +
            ")")
    List<WorkerEntity> getWsbThisMonth(Date billTime);


    @Select("SELECT * FROM `zzyj_laborservice_itax_salary_collect`\n" +
            "where DATE_FORMAT(bill_time, '%Y%m') = DATE_FORMAT(#{billTime}, '%Y%m')\n" +
            "and dr = 0 and bill_state in (1,3)\n" +
            "limit 1")
    SalaryCollectEntity getOneByBillTime(Date billTime);
}

