package com.ejianc.business.laborlaw.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.laborlaw.bean.CaseRegisterContractEntity;
import com.ejianc.business.laborlaw.bean.CaseRegisterContractEntity;
/**
 * 劳务公司-诉讼案件登记
 * 
 * @author generator
 * 
 */
 @TableName("zzyj_laborservice_case_register")
public class CaseRegisterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="contract_id")
    private String contractId; // 收入合同id
    @TableField(value="contract_name")
    private String contractName; // 收入合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_type")
    private String contractType; // 合同类型
    @TableField(value="project_manager_dept_id")
    private String projectManagerDeptId; // 项目管理部id
    @TableField(value="project_manager_dept")
    private String projectManagerDept; // 项目管理部
    @TableField(value="supplier_id")
    private String supplierId; // 乙方id
    @TableField(value="supplier")
    private String supplier; // 乙方
    @TableField(value="supplier_signer_id")
    private String supplierSignerId; // 乙方签订人id
    @TableField(value="supplier_signer_name")
    private String supplierSignerName; // 乙方签订人
    @TableField(value="plaintiff")
    private String plaintiff; // 原告
    @TableField(value="defendant")
    private String defendant; // 被告
    @TableField(value="case_mny")
    private BigDecimal caseMny; // 诉讼金额
    @TableField(value="case_type")
    private String caseType; // 案件类别
    @TableField(value="dispute_type_name")
    private String disputeTypeName; // 纠纷类型名称
    @TableField(value="case_state_name")
    private String caseStateName; // 案件状态
    @TableField(value="case_reason")
    private String caseReason; // 诉讼原因
    @TableField(value="first_party_id")
    private String firstPartyId; // 甲方id
    @TableField(value="first_party_name")
    private String firstPartyName; // 甲方
    @TableField(value="project_id")
    private String projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="dispute_type")
    private String disputeType; // 纠纷类型
    @TableField(value="service_date")
    private Date serviceDate; // 业务日期
    @TableField(value="case_code")
    private String caseCode; // 案号
    @TableField(value="self_code")
    private String selfCode; // 归档编号
    @TableField(value="third_person")
    private Long thirdPerson; // 第三人
    @TableField(value="third_person_name")
    private String thirdPersonName; // 第三人名称
    
    @TableField(exist=false)
    @SubEntity(serviceName="caseRegisterContractService",pidName = "zhuId")
    private List<CaseRegisterContractEntity> caseRegisterContractList = new ArrayList<>(); // 劳务公司-诉讼案件登记-合同详情
    @TableField(exist=false)
    @SubEntity(serviceName="caseRegisterPersonService",pidName = "zhuId")
    private List<CaseRegisterPersonEntity> caseRegisterPersonList = new ArrayList<>(); // 劳务公司-诉讼案件登记-当事人
    @TableField(exist = false)
    @SubEntity(serviceName = "infoRegisterService", pidName = "caseId")
    private List<InfoRegisterEntity> infoRegisterList = new ArrayList<>(); // 案件审理信息表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public String getProjectManagerDeptId() {
        return projectManagerDeptId;
    }

    public void setProjectManagerDeptId(String projectManagerDeptId) {
        this.projectManagerDeptId = projectManagerDeptId;
    }
    public String getProjectManagerDept() {
        return projectManagerDept;
    }

    public void setProjectManagerDept(String projectManagerDept) {
        this.projectManagerDept = projectManagerDept;
    }
    public String getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }
    public String getSupplierSignerId() {
        return supplierSignerId;
    }

    public void setSupplierSignerId(String supplierSignerId) {
        this.supplierSignerId = supplierSignerId;
    }
    public String getSupplierSignerName() {
        return supplierSignerName;
    }

    public void setSupplierSignerName(String supplierSignerName) {
        this.supplierSignerName = supplierSignerName;
    }
    public String getPlaintiff() {
        return plaintiff;
    }

    public void setPlaintiff(String plaintiff) {
        this.plaintiff = plaintiff;
    }
    public String getDefendant() {
        return defendant;
    }

    public void setDefendant(String defendant) {
        this.defendant = defendant;
    }
    public BigDecimal getCaseMny() {
        return caseMny;
    }

    public void setCaseMny(BigDecimal caseMny) {
        this.caseMny = caseMny;
    }
    public String getCaseType() {
        return caseType;
    }

    public void setCaseType(String caseType) {
        this.caseType = caseType;
    }
    public String getDisputeTypeName() {
        return disputeTypeName;
    }

    public void setDisputeTypeName(String disputeTypeName) {
        this.disputeTypeName = disputeTypeName;
    }
    public String getCaseStateName() {
        return caseStateName;
    }

    public void setCaseStateName(String caseStateName) {
        this.caseStateName = caseStateName;
    }
    public String getCaseReason() {
        return caseReason;
    }

    public void setCaseReason(String caseReason) {
        this.caseReason = caseReason;
    }
    public String getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(String firstPartyId) {
        this.firstPartyId = firstPartyId;
    }
    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getDisputeType() {
        return disputeType;
    }

    public void setDisputeType(String disputeType) {
        this.disputeType = disputeType;
    }
    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }
    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }
    public String getSelfCode() {
        return selfCode;
    }

    public void setSelfCode(String selfCode) {
        this.selfCode = selfCode;
    }


    public List<CaseRegisterContractEntity> getCaseRegisterContractList() {
        return caseRegisterContractList;
    }

    public void setCaseRegisterContractList(List<CaseRegisterContractEntity> caseRegisterContractList) {
        this.caseRegisterContractList = caseRegisterContractList;
    }

    public List<CaseRegisterPersonEntity> getCaseRegisterPersonList() {
        return caseRegisterPersonList;
    }

    public void setCaseRegisterPersonList(List<CaseRegisterPersonEntity> caseRegisterPersonList) {
        this.caseRegisterPersonList = caseRegisterPersonList;
    }

    public List<InfoRegisterEntity> getInfoRegisterList() {
        return infoRegisterList;
    }

    public void setInfoRegisterList(List<InfoRegisterEntity> infoRegisterList) {
        this.infoRegisterList = infoRegisterList;
    }

    public Long getThirdPerson() {
        return thirdPerson;
    }

    public void setThirdPerson(Long thirdPerson) {
        this.thirdPerson = thirdPerson;
    }

    public String getThirdPersonName() {
        return thirdPersonName;
    }

    public void setThirdPersonName(String thirdPersonName) {
        this.thirdPersonName = thirdPersonName;
    }
}
