package com.ejianc.business.itax.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.itax.bean.SalaryDetailEntity;
import com.ejianc.business.itax.bean.WorkerEntity;
import com.ejianc.business.itax.mapper.SalaryDetailMapper;
import com.ejianc.business.itax.service.ISalaryDetailService;
import com.ejianc.business.itax.service.IWorkerService;
import com.ejianc.business.itax.utils.DetailIndexExcelReaderZzyj;
import com.ejianc.business.itax.utils.IdCardCheck;
import com.ejianc.business.itax.vo.SalaryDetailVO;
import com.ejianc.business.laborservice.vo.LaborserviceIncomeContractVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.Account;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.itax.bean.SalaryEntity;
import com.ejianc.business.itax.service.ISalaryService;
import com.ejianc.business.itax.vo.SalaryVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 工人工资上传
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("salary")
public class SalaryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISalaryService service;

    @Autowired
    private SessionManager sessionManager;
    @Value("${ejc.roleid}")
    private Long roleId;

    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private ISalaryDetailService detailService;

    @Autowired
    private IWorkerService workerService;

    @Autowired
    private SalaryDetailMapper detailMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SalaryVO> saveOrUpdate(@RequestBody SalaryVO saveOrUpdateVO) {
    	SalaryEntity entity = BeanMapper.map(saveOrUpdateVO, SalaryEntity.class);
        UserContext userContextCache=sessionManager.getUserContext();
        if(entity.getId()==null||entity.getId()==0){

//            QueryParam param = new QueryParam();
//            param.getParams().put("billTime",new Parameter(QueryParam.EQ,entity.getBillTime()));
//            param.getParams().put("operatorName",new Parameter(QueryParam.EQ,entity.getOperatorName()));
//            List<SalaryEntity> projectCheckEntity = service.queryList(param);
//
//            if (CollectionUtils.isNotEmpty(projectCheckEntity)){
//                throw new BusinessException("该月次劳务队存在单据，请直接在原单据上修改！");
//            }

            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //设置创建人姓名  
            entity.setCreateUserName(userContextCache.getUserName());
            entity.setCreateUserId(userContextCache.getUserId());
        }else{
            //设置修改人姓名  
            entity.setUpdateUserName(userContextCache.getUserName());
        }

    	service.saveOrUpdate(entity, false);


        SalaryEntity salaryEntity1 = service.selectById(entity.getId());
        List<SalaryDetailEntity> salaryDetailList = salaryEntity1.getSalaryDetailList();
        BigDecimal kczl = salaryDetailList.stream().map(SalaryDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        salaryEntity1.setMoneySum(kczl);

        service.saveOrUpdate(salaryEntity1);

        //detailService.calculateItax(salaryEntity1);

        SalaryVO vo = BeanMapper.map(salaryEntity1, SalaryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SalaryVO> queryDetail(Long id) {
    	SalaryEntity entity = service.selectById(id);
    	SalaryVO vo = BeanMapper.map(entity, SalaryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalaryVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SalaryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SalaryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalaryVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("userNames");
        fuzzyFields.add("userIdcards");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        boolean viewFlag = false;
        UserContext userContextCache = sessionManager.getUserContext();
        List<Long> roleIds = new ArrayList<>();
        roleIds.add(roleId);
        CommonResponse<List<RoleUserRelationVO>> roleResp = roleApi.getRoleUser(roleIds, null);
        if(!roleResp.isSuccess()){
            throw new BusinessException("网络异常，获取发送信息角色， 请稍后再试");
        }
        List<RoleUserRelationVO> relationVOS = roleResp.getData();
        List<String> userIds = relationVOS.stream().map(RoleUserRelationVO::getUserId).map(Object::toString).collect(Collectors.toList());

        if (userIds.contains(userContextCache.getUserId().toString())){
            viewFlag = true;
        }
        if (!viewFlag){
            param.getParams().put("createUserId",new Parameter(QueryParam.EQ,userContextCache.getUserId()));
        }
        IPage<SalaryVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<SalaryVO> pageList = service.queryPageList(wrapper,page);
        page.setRecords(pageList);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("userNames");
        fuzzyFields.add("userIdcards");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        boolean viewFlag = false;
        UserContext userContextCache = sessionManager.getUserContext();
        List<Long> roleIds = new ArrayList<>();
        roleIds.add(roleId);
        CommonResponse<List<RoleUserRelationVO>> roleResp = roleApi.getRoleUser(roleIds, null);
        if(!roleResp.isSuccess()){
            throw new BusinessException("网络异常，获取发送信息角色， 请稍后再试");
        }
        List<RoleUserRelationVO> relationVOS = roleResp.getData();
        List<String> userIds = relationVOS.stream().map(RoleUserRelationVO::getUserId).map(Object::toString).collect(Collectors.toList());

        if (userIds.contains(userContextCache.getUserId().toString())){
            viewFlag = true;
        }
        if (!viewFlag){
            param.getParams().put("createUserId",new Parameter(QueryParam.EQ,userContextCache.getUserId()));
        }
        IPage<SalaryVO> page = new Page<>(param.getPageIndex(), 10000);
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<SalaryVO> pageList = service.queryPageList(wrapper,page);

        //todo:字段翻译等等
        for (SalaryVO salaryVO : pageList) {
            if (salaryVO.getIsError() != null && salaryVO.getIsError() == 1){
                salaryVO.setUserNames("是");
            }else {
                salaryVO.setUserNames("否");
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", pageList);
        ExcelExport.getInstance().export("Salary-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refSalaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SalaryVO>> refSalaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SalaryEntity> page = service.queryPage(param,false);
        IPage<SalaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalaryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Salary-import.xlsx", "工资导入模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response,Long id) throws ParseException {
        SalaryEntity salaryEntity = service.selectById(id);
        Map<String, String> idcodeNameMap = salaryEntity.getSalaryDetailList().stream().collect(Collectors.toMap(SalaryDetailEntity::getIdNum, SalaryDetailEntity::getName, (v1, v2) -> v2));

        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SalaryDetailVO> successList = new ArrayList<>();
        List<SalaryDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
            if (result != null && result.size() > 0) {
                List<String> idCardList = new ArrayList<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    idCardList.add(datas.get(1).trim());
                }
                LambdaQueryWrapper<WorkerEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
                lambdaQueryWrapper1.eq(WorkerEntity::getState, 1);
                lambdaQueryWrapper1.in(WorkerEntity::getIdNum, idCardList);
                lambdaQueryWrapper1.isNotNull(WorkerEntity::getIdNum);
                List<WorkerEntity> rosterEntityList = workerService.list(lambdaQueryWrapper1);
                Map<String, WorkerEntity> userMap = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdNum(), Function.identity()));

                //给每行赋值
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SalaryDetailVO detailVO = new SalaryDetailVO();
                    detailVO.setOperatorName(salaryEntity.getOperatorName());
                    detailVO.setProjectName(salaryEntity.getProjectName());
                    detailVO.setOrgName(salaryEntity.getOrgName());

                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    if (StringUtils.isNotBlank(datas.get(1)) || StringUtils.isNotBlank(datas.get(0)) ||StringUtils.isNotBlank(datas.get(3))) {
                        try {
                            //身份证号
                            String idCard = datas.get(1).trim();
                            detailVO.setIdNum(idCard);

                            Integer inte = detailMapper.lastMonthWorkerIsUpload(salaryEntity.getBillTime(), idCard);
                            if(inte != null && inte > 0){
                                detailVO.setLastMonthIsUpload("已上传");
                            }else {
                                detailVO.setLastMonthIsUpload("未上传");
                            }

                            String userName = datas.get(0).trim();
                            detailVO.setName(userName);

                            String money = datas.get(3);
                            detailVO.setMoney(StringUtils.isNotBlank(money) ? new BigDecimal(money) : null);

                            IdCardCheck idCardCheck = new IdCardCheck();
                            if(!idCardCheck.checkIdCardNum(idCard)) {
                                detailVO.setErrorMsg("身份证号格式错误！");
                                errorList.add(detailVO);
                                continue;
                            }
                            if (idcodeNameMap.containsKey(idCard)){
                                detailVO.setErrorMsg("此身份证号已存在！");
                                errorList.add(detailVO);
                                continue;
                            }else {
                                idcodeNameMap.put(idCard,userName);
                            }

                        } catch (Exception e) {
                            detailVO.setErrorMsg("名称、身份证号、本次发放金额错误！");
                            errorList.add(detailVO);
                            continue;
                        }
                    }else {
                        detailVO.setErrorMsg("名称、身份证号、本次发放金额不允许为空！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //
                    if(userMap.containsKey(detailVO.getIdNum())) {
                        if ( !detailVO.getName().equals(userMap.get(detailVO.getIdNum()).getName())){
                            detailVO.setErrorMsg("名称、身份证号不匹配！");
                            errorList.add(detailVO);
                            continue;
                        }
                        detailVO.setUserState(1);//已登记
                        detailVO.setIsRegist("已登记");//已登记
                    }else {
                        detailVO.setUserState(2);//未登记
                        detailVO.setIsRegist("未登记");//未登记
                    }
                    //手机号
                    if (StringUtils.isNotBlank(datas.get(2))) {
                        detailVO.setPhone(datas.get(2));
                    }else {
                        detailVO.setErrorMsg("手机号不允许为空！");
                        errorList.add(detailVO);
                        continue;
                    }

                    detailVO.setRowState("add");
                    detailVO.setSalaryPayState("未发放");
                    detailVO.setItaxState("未收取");
                    detailVO.setLastMonthState("未申报");
                    successList.add(detailVO);
                    SalaryDetailEntity map = BeanMapper.map(detailVO, SalaryDetailEntity.class);
                    map.setPid(id);
                    map.setId(null);
                    detailService.saveOrUpdate(map);
                }
            }
        }

        SalaryEntity salaryEntity1 = service.selectById(id);
        List<SalaryDetailEntity> salaryDetailList = salaryEntity1.getSalaryDetailList();
        BigDecimal kczl = salaryDetailList.stream().map(SalaryDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        salaryEntity1.setMoneySum(kczl);
        service.saveOrUpdate(salaryEntity1);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryNoPayList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalaryDetailVO>> queryNoPayList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("operatorName");
        fuzzyFields.add("name");
        fuzzyFields.add("idNum");


        IPage<SalaryDetailVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<SalaryDetailVO> pageList = service.queryNoPayList(wrapper,page);
        page.setRecords(pageList);
        return CommonResponse.success("查询列表数据成功！",page);
    }


}
