package com.ejianc.business.itax.service;

import com.ejianc.business.itax.bean.SalaryEntity;
import com.ejianc.business.itax.bean.WorkerEntity;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.itax.bean.SalaryCollectEntity;

import java.util.Date;
import java.util.List;

/**
 * 工人工资汇总
 * 
 * @author generator
 * 
 */
public interface ISalaryCollectService extends IBaseService<SalaryCollectEntity> {
    SalaryCollectEntity calculateCollectItax(SalaryCollectEntity salaryEntity);

    /**
     * 三个月0申报、未申报
     * @param billTime
     * @return
     */
    List<WorkerEntity> getWsb3Month(Date billTime);

    /**
     * 本月未申报
     * @param billTime
     * @return
     */
    List<WorkerEntity> getWsbThisMonth(Date billTime);

}
