package com.ejianc.business.laborservice.mapper;

import com.ejianc.business.laborservice.vo.LaborserviceExpendContractVO;
import com.ejianc.business.laborservice.vo.LaborserviceProjectVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.laborservice.bean.LaborserviceTeamEntity;
import org.apache.ibatis.annotations.Select;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 劳务公司队伍管理
 * 
 * @author generator
 * 
 */
@Mapper
public interface LaborserviceTeamMapper extends BaseCrudMapper<LaborserviceTeamEntity> {

    @Select({
        "select b.*,a.count contractCount from (select project_id,count(*) count from zzyj_laborservice_income_contract " +
         "where supplier_signer_id=#{teamId} GROUP BY project_id) a left join zzyj_laborservice_project " +
         "b on a.project_id=b.id"
    })
    List<LaborserviceProjectVO> getProjectInfoByTeamId(@RequestParam("teamId") Long teamId);



    List<LaborserviceExpendContractVO> getThisYearTeamData();
}
