package com.ejianc.business.itax.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.itax.vo.SalaryDetailVO;
import com.ejianc.business.itax.vo.SalaryVO;
import com.ejianc.business.laborservice.vo.LaborserviceIncomeContractVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.itax.bean.SalaryEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 工人工资上传
 * 
 * @author generator
 * 
 */
@Mapper
public interface SalaryMapper extends BaseCrudMapper<SalaryEntity> {

    @Select("SELECT id_num \n" +
            "FROM  zzyj_laborservice_itax_salary_detail\n" +
            "where pid = #{pid} and dr = 0\n" +
            "GROUP BY id_num\n" +
            "HAVING  COUNT(id_num) > 1")
    List<String> idNumThanZero(Long pid);


    List<SalaryVO> queryPageList(@Param(Constants.WRAPPER) QueryWrapper changeToQueryWrapper, @Param("page") IPage<SalaryVO> page);

    List<SalaryDetailVO> queryNoPayList(@Param(Constants.WRAPPER) QueryWrapper changeToQueryWrapper, @Param("page") IPage<SalaryDetailVO> page);

}
