package com.ejianc.business.itax.service.impl;

import com.ejianc.business.itax.bean.SalaryCollectDetailEntity;
import com.ejianc.business.itax.bean.SalaryEntity;
import com.ejianc.business.itax.bean.WorkerEntity;
import com.ejianc.business.itax.service.ISalaryCollectDetailService;
import com.ejianc.business.itax.service.ISalaryDetailService;
import com.ejianc.business.itax.service.ISalaryService;
import com.ejianc.business.laborservice.bean.ExpendApplyEntity;
import com.ejianc.business.laborservice.bean.LaborserviceExpendContractEntity;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractEntity;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeReceivingEntity;
import com.ejianc.business.laborservice.service.IExpendApplyService;
import com.ejianc.business.laborservice.service.ILaborserviceExpendContractService;
import com.ejianc.business.laborservice.service.ILaborserviceIncomeContractService;
import com.ejianc.business.laborservice.service.ILaborserviceIncomeReceivingService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.itax.mapper.SalaryCollectMapper;
import com.ejianc.business.itax.bean.SalaryCollectEntity;
import com.ejianc.business.itax.service.ISalaryCollectService;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 工人工资汇总
 * 
 * @author generator
 * 
 */
@Service("salaryCollectService")
public class SalaryCollectServiceImpl extends BaseServiceImpl<SalaryCollectMapper, SalaryCollectEntity> implements ISalaryCollectService{

    @Autowired
    private ISalaryDetailService salaryDetailService;
    @Autowired
    private ISalaryCollectDetailService collectDetailService;
    @Autowired
    private SalaryCollectMapper salaryCollectMapper;

    @Autowired
    private ILaborserviceExpendContractService expendContractService;
    @Autowired
    private ILaborserviceIncomeContractService incomeContractService;

    @Autowired
    private IExpendApplyService expendApplyService;
    @Autowired
    private ILaborserviceIncomeReceivingService incomeReceivingService;

    @Override
    public SalaryCollectEntity calculateCollectItax(SalaryCollectEntity salaryEntity) {

        Date billTime = salaryEntity.getBillTime();
        List<SalaryCollectDetailEntity> salaryCollectDetailEntities = baseMapper.calculateCollectItax(billTime);
        if (CollectionUtils.isNotEmpty(salaryCollectDetailEntities)){
            for (SalaryCollectDetailEntity salaryCollectDetailEntity : salaryCollectDetailEntities) {
                salaryCollectDetailEntity.setPid(salaryEntity.getId());
                // thisMonthIncomeItax  本月应纳税所得额---本年已申报+今年未申报+本月累计办理代发 - 累计减除 - 专项附加扣除  ，小于0为0
                // thisMonthItax  应缴个税----总应缴税额*公式
                BigDecimal bigDecimal = salaryCollectDetailEntity.getThisYearIncome()
                        .add(salaryCollectDetailEntity.getLastMonthWsbIncome())
                        .add(salaryCollectDetailEntity.getThisMonthDlffje())
                        .subtract(salaryCollectDetailEntity.getExpenseReduction())
                        .subtract(salaryCollectDetailEntity.getSpecialDeduction()).setScale(4, RoundingMode.HALF_UP);
                if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    salaryCollectDetailEntity.setThisMonthIncomeItax(bigDecimal);
                    salaryCollectDetailEntity.setThisMonthItax(salaryDetailService.calculate(bigDecimal));
                }else {
                    salaryCollectDetailEntity.setThisMonthIncomeItax(BigDecimal.ZERO);
                    salaryCollectDetailEntity.setThisMonthItax(BigDecimal.ZERO);
                }
            }

            collectDetailService.saveOrUpdateBatch(salaryCollectDetailEntities);
            //修改申报状态
            salaryCollectMapper.updateSbState(billTime,"已申报");


            List<SalaryEntity> salaryListByTime = salaryCollectMapper.getSalaryListByTime(billTime);
            for (SalaryEntity entity : salaryListByTime) {
                BigDecimal bigDecimal = salaryCollectMapper.paySalaryMoney(entity.getId());
                //推送生成收款单
                LaborserviceExpendContractEntity laborserviceExpendContractEntity = expendContractService.selectById(entity.getExpendContractId());
                if("甲方总包代发".equals(entity.getPayType())){
                   LaborserviceIncomeContractEntity laborserviceIncomeContractEntity = incomeContractService.selectById(laborserviceExpendContractEntity.getIncomeContractId());

                    LaborserviceIncomeReceivingEntity laborserviceIncomeReceivingEntity = new LaborserviceIncomeReceivingEntity();
                    laborserviceIncomeReceivingEntity.setBillCode(entity.getBillCode());

                    laborserviceIncomeReceivingEntity.setIncomeContractId(laborserviceIncomeContractEntity.getId());
                    laborserviceIncomeReceivingEntity.setIncomeContractCode(laborserviceIncomeContractEntity.getBillCode());
                    laborserviceIncomeReceivingEntity.setIncomeContractName(laborserviceIncomeContractEntity.getContractName());
                    laborserviceIncomeReceivingEntity.setContractAccumulateTaxMny(laborserviceIncomeContractEntity.getContractAccumulateTaxMny());
                    laborserviceIncomeReceivingEntity.setContractStatus(laborserviceIncomeContractEntity.getContractStatus());
                    laborserviceIncomeReceivingEntity.setOrgId(laborserviceIncomeContractEntity.getOrgId());
                    laborserviceIncomeReceivingEntity.setOrgName(laborserviceIncomeContractEntity.getOrgName());

                    laborserviceIncomeReceivingEntity.setProjectId(laborserviceIncomeContractEntity.getProjectId());
                    laborserviceIncomeReceivingEntity.setProjectName(laborserviceIncomeContractEntity.getProjectName());
                    laborserviceIncomeReceivingEntity.setFirstPartyId(laborserviceIncomeContractEntity.getFirstPartyId());
                    laborserviceIncomeReceivingEntity.setFirstPartyName(laborserviceIncomeContractEntity.getFirstPartyName());
                    laborserviceIncomeReceivingEntity.setSupplierSignerId(laborserviceIncomeContractEntity.getSupplierSignerId());
                    laborserviceIncomeReceivingEntity.setSupplierSignerName(laborserviceIncomeContractEntity.getSupplierSignerName());
                    laborserviceIncomeReceivingEntity.setLaborIdcard(laborserviceIncomeContractEntity.getSupplierSignerCertId());
                    laborserviceIncomeReceivingEntity.setReceiveType("甲方总包代发");
                    laborserviceIncomeReceivingEntity.setBillSource("自动生成");
                    laborserviceIncomeReceivingEntity.setBillSourceId(entity.getId()+"");
                    laborserviceIncomeReceivingEntity.setBillState(1);
                    laborserviceIncomeReceivingEntity.setReceivingAmount(bigDecimal);
                    incomeReceivingService.save(laborserviceIncomeReceivingEntity);

                }
                //推送生成支付单
                ExpendApplyEntity laborserviceIncomeReceivingEntity = new ExpendApplyEntity();
                laborserviceIncomeReceivingEntity.setBillCode(entity.getBillCode());

                laborserviceIncomeReceivingEntity.setIncomeContractId(laborserviceExpendContractEntity.getId());
                laborserviceIncomeReceivingEntity.setIncomeContractCode(laborserviceExpendContractEntity.getBillCode());
                laborserviceIncomeReceivingEntity.setIncomeContractName(laborserviceExpendContractEntity.getContractName());
                laborserviceIncomeReceivingEntity.setContractAccumulateTaxMny(laborserviceExpendContractEntity.getContractAccumulateTax());
                laborserviceIncomeReceivingEntity.setContractStatus(laborserviceExpendContractEntity.getContractStatus());
                laborserviceIncomeReceivingEntity.setOrgId(laborserviceExpendContractEntity.getOrgId());
                laborserviceIncomeReceivingEntity.setOrgName(laborserviceExpendContractEntity.getOrgName());
                laborserviceIncomeReceivingEntity.setProjectId(laborserviceExpendContractEntity.getProjectId());
                laborserviceIncomeReceivingEntity.setProjectName(laborserviceExpendContractEntity.getProjectName());
                laborserviceIncomeReceivingEntity.setFirstPartyId(laborserviceExpendContractEntity.getFirstPartyId());
                laborserviceIncomeReceivingEntity.setFirstPartyName(laborserviceExpendContractEntity.getFirstPartyName());
                //laborserviceIncomeReceivingEntity.setSupplierSignerId(laborserviceExpendContractEntity.getSupplierId());
                laborserviceIncomeReceivingEntity.setSupplierSignerName(laborserviceExpendContractEntity.getSupplier());
                laborserviceIncomeReceivingEntity.setLaborIdcard(laborserviceExpendContractEntity.getSupplierSignerCertId());
                laborserviceIncomeReceivingEntity.setExpendType(entity.getPayType());
                laborserviceIncomeReceivingEntity.setBillSource("自动生成");
                laborserviceIncomeReceivingEntity.setBillSourceId(entity.getId()+"");
                laborserviceIncomeReceivingEntity.setBillState(1);
                laborserviceIncomeReceivingEntity.setExpendAmount(bigDecimal);
                expendApplyService.save(laborserviceIncomeReceivingEntity);

            }


        }

        return salaryEntity;
    }

    @Override
    public List<WorkerEntity> getWsb3Month(Date billTime) {
        return baseMapper.getWsb3Month(billTime);
    }

    @Override
    public List<WorkerEntity> getWsbThisMonth(Date billTime) {
        return baseMapper.getWsbThisMonth(billTime);
    }


}
