package com.ejianc.business.itax.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.itax.bean.*;
import com.ejianc.business.itax.mapper.SalaryCollectMapper;
import com.ejianc.business.itax.service.ISalaryCollectService;
import com.ejianc.business.itax.service.ISalaryService;
import com.ejianc.business.itax.service.IWorkerService;
import com.ejianc.business.itax.vo.WorkerVO;
import com.ejianc.business.laborservice.bean.LaborserviceExpendContractEntity;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.itax.mapper.SalaryDetailMapper;
import com.ejianc.business.itax.service.ISalaryDetailService;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 工人工资上传明细
 * 
 * @author generator
 * 
 */
@Service("salaryDetailService")
public class SalaryDetailServiceImpl extends BaseServiceImpl<SalaryDetailMapper, SalaryDetailEntity> implements ISalaryDetailService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWorkerService workerService;

    @Autowired
    private ISalaryService salaryService;
    @Autowired
    private ISalaryCollectService collectService;

    @Autowired
    private SalaryCollectMapper collectMapper;
    @Override
    public SalaryEntity calculateItax(SalaryEntity salaryEntity) {
        List<SalaryDetailEntity> detailList = salaryEntity.getSalaryDetailList();

        //判断上个月是否完成工资汇总，已汇总则使用工资发放状态、申报状态；未汇总则使用个税收取状态
        SalaryCollectEntity oneByBillTime = collectMapper.getOneByBillTime(salaryEntity.getBillTime());

        if(CollectionUtils.isNotEmpty(detailList)){

            List<String> idCardList = detailList.stream().map(SalaryDetailEntity::getIdNum).collect(Collectors.toList());
            logger.info("人员身份证号m: {}", JSONObject.toJSONString(idCardList));

            //获取工人数据
            Map<String, WorkerEntity> map = new HashMap<>();
            LambdaQueryWrapper<WorkerEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
            lambdaQueryWrapper1.eq(WorkerEntity::getState, 1);
            lambdaQueryWrapper1.in(WorkerEntity::getIdNum, idCardList);
            lambdaQueryWrapper1.isNotNull(WorkerEntity::getIdNum);
            List<WorkerEntity> rosterEntityList = workerService.list(lambdaQueryWrapper1);
            map = rosterEntityList.stream().collect(Collectors.toMap(p -> p.getIdNum(), Function.identity()));
            BigDecimal fiveThousand = new BigDecimal(5000);
            for (SalaryDetailEntity salaryDetailEntity : detailList) {
                /**
                 * 从人员清单中获取信息
                 */
                WorkerEntity workerEntity = null;
                if (map.containsKey(salaryDetailEntity.getIdNum())){
                    workerEntity=  map.get(salaryDetailEntity.getIdNum());
                }

                // lastMonthState  上月申报状态---从历史工资表中获取上月的个税单是否有此人信息，有则填写上月已申报，否则填写上月未申报
                //👆本月申报状态 已申报，申报0，未申报  （手动修改）
                if (StringUtils.isEmpty(salaryDetailEntity.getLastMonthState())) {
                    salaryDetailEntity.setLastMonthState("未申报");
                }
                //本条工资发放状态  (手动修改)
                if (StringUtils.isEmpty(salaryDetailEntity.getSalaryPayState())) {
                    salaryDetailEntity.setSalaryPayState("未发放");
                }
                //本条个税收取状态  (手动修改)
                if (StringUtils.isEmpty(salaryDetailEntity.getItaxState())) {
                    salaryDetailEntity.setItaxState("未收取");
                }
                BigDecimal thisYearIncome = BigDecimal.ZERO;
                BigDecimal thisYearItax = BigDecimal.ZERO;
                //monthNum 计算个税入职月份----上月申报的话，从人员信息表获取入职月份（去年的就是1月）
                // isRegist  是否在系统登记----人员信息表的登记状态
                if (workerEntity != null){
                    //系统中有此人
                    int month = DateUtil.month(workerEntity.getEffectiveStartTime())+1;
                    int year = DateUtil.year(workerEntity.getEffectiveStartTime());
                    int yearNow = DateUtil.year(salaryEntity.getBillTime());
                    if (yearNow > year) {
                        salaryDetailEntity.setMonthNum(1);
                    } else {
                        salaryDetailEntity.setMonthNum(month);
                        if (oneByBillTime != null) {
                            //如果不是第一次发工资 且 不是一月份，则通过上月的单子获取数据
                            thisYearIncome = baseMapper.thisYearWorkerRegistMny(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum());
                            thisYearItax = baseMapper.thisYearWorkerRegistTaxMny(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum());
                        }else {
                            thisYearIncome = baseMapper.thisYearWorkerRegistMnyWsb(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum());
                            thisYearItax = baseMapper.thisYearWorkerRegistTaxMnyWsb(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum());
                        }
                    }
                    //salaryDetailEntity.setIsRegist("验证通过");
                }else {
                    //系统中无此人
                    //未在系统中则默认是上个月
                    salaryDetailEntity.setMonthNum(DateUtil.month(salaryEntity.getBillTime()) == 0 ?1:DateUtil.month(salaryEntity.getBillTime()));
                    //salaryDetailEntity.setIsRegist("未校验");
                    if (oneByBillTime == null) {
                        //上个月工资未汇总
                        thisYearIncome = baseMapper.thisYearWorkerRegistMnyWsb(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum());
                        thisYearItax = baseMapper.thisYearWorkerRegistTaxMnyWsb(salaryEntity.getBillTime(), salaryDetailEntity.getIdNum());
                        if (thisYearIncome.compareTo(BigDecimal.ZERO) == 1){
                            int monthNow = DateUtil.month(salaryEntity.getBillTime());
                            salaryDetailEntity.setMonthNum(monthNow>=2?monthNow-1:1);
                        }
                    }

                }


                // thisYearIncome  截至本单已申报本年度累计收入---此人历史申报的收入金额之和
                /**
                 * 1212修改 thisYearIncome  截至本单已申报本年度累计收入---此人在上个月申报的金额+上个月年度累计收入
                 * 如果此人状态为已登记才会有上个月的金额
                 *
                 * 👇👇👇👇👇👇
                 *
                 * 此人上个月可能工资尚未完成发放、申报,此时根据个税收取状态判断
                 */
                salaryDetailEntity.setThisYearIncome(thisYearIncome);


                // thisMonthNum  本月代发次数---本月此身份证号在工资单中出现的次数  (+1)
                salaryDetailEntity.setThisMonthNum(baseMapper.thisMonthWorkerRegistNum(salaryEntity.getBillTime(),salaryDetailEntity.getIdNum()));

                // thisMonthDlffje  本月累计办理代发金额---本月已经提交的工资单中此人的工资求和 （+此单据的本月代发金额？）
                salaryDetailEntity.setThisMonthDlffje(
                        baseMapper.thisMonthWorkerRegistMny(salaryEntity.getBillTime(),salaryDetailEntity.getIdNum())
                                //.add(salaryDetailEntity.getMoney())
                                .setScale(4, RoundingMode.HALF_UP));



                // expenseReduction  累计减除费用---按申报月份，每个月5K
                //241213 expenseReduction  累计减除费用---如果已入职 入职月份，每个月5K；如果未入职 就只有5K
                // 此人上个月可能工资尚未完成发放、申报,此时已入职的人没有问题，未入职的需要查询上个月工资单的个税收取状态判断
                //salaryDetailEntity.setExpenseReduction(baseMapper.thisYearWorkerRegistNum(salaryEntity.getBillTime(),salaryDetailEntity.getIdNum()));


                salaryDetailEntity.setExpenseReduction(new BigDecimal(DateUtil.month(salaryEntity.getBillTime())-salaryDetailEntity.getMonthNum()+2).multiply(fiveThousand).setScale(4, RoundingMode.HALF_UP));


                // thisYearItax  截至本月已申报个税---此人历史申报的税额之和    thisYearItax
                // 上个月未申报的情况下，需要查上个月的已收取个税状态 判断金额
                salaryDetailEntity.setThisYearItax(thisYearItax);


                // specialDeduction  专项附加扣除---为空时，暂时全为0
                if(salaryDetailEntity.getSpecialDeduction() == null) {
                    salaryDetailEntity.setSpecialDeduction(BigDecimal.ZERO);
                }

                // lastMonthWsbItax  今年未申报个税---
                salaryDetailEntity.setLastMonthWsbItax(null);

                // lastMonthWsbIncome  今年未申报收入金额---已发放但申报0的
                salaryDetailEntity.setLastMonthWsbIncome(baseMapper.thisYearWorkerNoRegistMny(salaryEntity.getBillTime(),salaryDetailEntity.getIdNum()));

                // thisMonthPrepayItax  本月预缴个税---此人本月其他单子下的计算个税字段金额之和
                salaryDetailEntity.setThisMonthPrepayItax(baseMapper.thisMonthWorkerItaxMny(salaryEntity.getBillTime(),salaryDetailEntity.getIdNum(),salaryEntity.getId()));

                // thisMonthIncomeItax  本月应纳税所得额---本年已申报+今年未申报+本月累计办理代发 - 累计减除 - 专项附加扣除  ，小于0为0
                // thisMonthItax  应缴个税----总应缴税额- 累计已申报个税 - 其他单子已经预缴的税
                BigDecimal bigDecimal = salaryDetailEntity.getThisYearIncome()
                       // .add(salaryDetailEntity.getLastMonthWsbIncome())
                        .add(salaryDetailEntity.getThisMonthDlffje())
                        .subtract(salaryDetailEntity.getExpenseReduction())
                        .subtract(salaryDetailEntity.getSpecialDeduction()).setScale(4, RoundingMode.HALF_UP);
                if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    salaryDetailEntity.setThisMonthIncomeItax(bigDecimal);
                    salaryDetailEntity.setThisMonthItax(calculate(bigDecimal).
                            subtract(salaryDetailEntity.getThisMonthPrepayItax()).
                            subtract(salaryDetailEntity.getThisYearItax()).
                            setScale(4, RoundingMode.HALF_UP));
                }else {
                    salaryDetailEntity.setThisMonthIncomeItax(BigDecimal.ZERO);
                    salaryDetailEntity.setThisMonthItax(BigDecimal.ZERO);
                }
                // 👆thisMonthItax  应缴个税----


                // thisMonthItaxYj 已收取个税--手动修改
                salaryDetailEntity.setThisMonthItaxYj(BigDecimal.ZERO);

            }

            this.updateBatchById(detailList);

            /**
             * 根据子表计算主表合计值
             */
            BigDecimal thisMonthItaxTotal = BigDecimal.ZERO;
            BigDecimal thisMonthItaxYjTotal = BigDecimal.ZERO;
            String lastMonthState = "已申报";
            for (SalaryDetailEntity salaryDetailEntity : detailList) {
                salaryDetailEntity.setItaxState("已收取");
                salaryDetailEntity.setThisMonthItaxYj(salaryDetailEntity.getThisMonthItax());


                if(salaryEntity.getId().equals(salaryDetailEntity.getPid())){
                    thisMonthItaxTotal = thisMonthItaxTotal.add(salaryDetailEntity.getThisMonthItax());
                    thisMonthItaxYjTotal = thisMonthItaxYjTotal.add(salaryDetailEntity.getThisMonthItaxYj());
                    if("未申报".equals(salaryDetailEntity.getLastMonthState())){
                        lastMonthState = "未申报";
                    }
                }

            }

            salaryEntity.setThisMonthItaxTotal(thisMonthItaxTotal);
            salaryEntity.setThisMonthItaxYjTotal(thisMonthItaxYjTotal);
            salaryEntity.setLastMonthState(lastMonthState);

        }

        return salaryEntity;
    }

    /**
     *累计预扣预缴应纳税所得额 来计算所得税
     *
     * @param mny
     * @return
     */
    @Override
    public BigDecimal calculate(BigDecimal mny){
        //0<=x<=36000 3%  0
        //36000<x<=144000  10  2520
        //300000  20  16920
        //420000  25  31920
        //660000  30  52920
        //960000  35  85920
        //>   45  181920
        BigDecimal bigDecimal = new BigDecimal(0);
        if(mny.compareTo(BigDecimal.ZERO) < 0){
            throw new BusinessException("金额计算错误！"+mny);
        }
        if (mny.compareTo(new BigDecimal(36000)) <= 0){
            bigDecimal = mny.multiply(new BigDecimal(0.03)).setScale(4,RoundingMode.HALF_UP);
        }else if (mny.compareTo(new BigDecimal(144000)) <= 0){
            bigDecimal = mny.multiply(new BigDecimal(0.1)).subtract(new BigDecimal(2520)).setScale(4,RoundingMode.HALF_UP);
        }else if (mny.compareTo(new BigDecimal(300000)) <= 0){
            bigDecimal = mny.multiply(new BigDecimal(0.2)).subtract(new BigDecimal(16920)).setScale(4,RoundingMode.HALF_UP);
        }else if (mny.compareTo(new BigDecimal(420000)) <= 0){
            bigDecimal = mny.multiply(new BigDecimal(0.25)).subtract(new BigDecimal(31920)).setScale(4,RoundingMode.HALF_UP);
        }else if (mny.compareTo(new BigDecimal(660000)) <= 0){
            bigDecimal = mny.multiply(new BigDecimal(0.3)).subtract(new BigDecimal(52920)).setScale(4,RoundingMode.HALF_UP);
        }else if (mny.compareTo(new BigDecimal(960000)) <= 0){
            bigDecimal = mny.multiply(new BigDecimal(0.35)).subtract(new BigDecimal(85920)).setScale(4,RoundingMode.HALF_UP);
        }else{
            bigDecimal = mny.multiply(new BigDecimal(0.45)).subtract(new BigDecimal(181920)).setScale(4,RoundingMode.HALF_UP);
        }
        return bigDecimal;
    }
    public static void main(String[] args) {

    }
}
