package com.ejianc.business.laborservice.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 劳务公司预征信息
 * 
 * @author generator
 * 
 */
 @TableName("zzyj_laborservice_pre_requisition")
public class LaborservicePreRequisitionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="vat")
    private BigDecimal vat; // 增值税
    @TableField(value="vat_rate")
    private BigDecimal vatRate; // 增值税税率
    @TableField(value="city_construction_tax")
    private BigDecimal cityConstructionTax; // 城建税
    @TableField(value="education_addition")
    private BigDecimal educationAddition; // 教育费附加
    @TableField(value="local_education_addition")
    private BigDecimal localEducationAddition; // 地方教育费附加
    @TableField(value="stamp_tax")
    private BigDecimal stampTax; // 印花税
    @TableField(value="fund")
    private BigDecimal fund; // 基金
    @TableField(value="personal_income_tax")
    private BigDecimal personalIncomeTax; // 个人所得税
    @TableField(value="corporate_income_tax")
    private BigDecimal corporateIncomeTax; // 企业所得税
    @TableField(value="water_construction_income")
    private BigDecimal waterConstructionIncome; // 水建收入
    @TableField(value="env_protection_tax")
    private BigDecimal envProtectionTax; // 环保税
    @TableField(value="water_resources")
    private BigDecimal waterResources; // 水资源
    @TableField(value="other_items")
    private BigDecimal otherItems; // 其他项目
    @TableField(value="additional_tax_total")
    private BigDecimal additionalTaxTotal; // 附加税合计
    @TableField(value="tax_total")
    private BigDecimal taxTotal; // 税费合计
    @TableField(value="national_tax_paid_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date nationalTaxPaidDate; // 国税完税日期
    @TableField(value="national_tax_payment_cert_num")
    private String nationalTaxPaymentCertNum; // 国税完税凭证号
    @TableField(value="national_tax_payment_org_id")
    private String nationalTaxPaymentOrgId; // 国税完税机构Id
    @TableField(value="national_tax_payment_org_name")
    private String nationalTaxPaymentOrgName; // 国税完税机构名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value = "source_contract_id")
    private Long sourceContractId; //关联合同id
    @TableField(value = "source_contract_name")
    private String sourceContractName;//关联合同名称
    @TableField(value = "invoice_num")
    private BigDecimal invoiceNum; //发票票号
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getVat() {
        return vat;
    }

    public void setVat(BigDecimal vat) {
        this.vat = vat;
    }
    public BigDecimal getVatRate() {
        return vatRate;
    }

    public void setVatRate(BigDecimal vatRate) {
        this.vatRate = vatRate;
    }
    public BigDecimal getCityConstructionTax() {
        return cityConstructionTax;
    }

    public void setCityConstructionTax(BigDecimal cityConstructionTax) {
        this.cityConstructionTax = cityConstructionTax;
    }
    public BigDecimal getEducationAddition() {
        return educationAddition;
    }

    public void setEducationAddition(BigDecimal educationAddition) {
        this.educationAddition = educationAddition;
    }
    public BigDecimal getLocalEducationAddition() {
        return localEducationAddition;
    }

    public void setLocalEducationAddition(BigDecimal localEducationAddition) {
        this.localEducationAddition = localEducationAddition;
    }
    public BigDecimal getStampTax() {
        return stampTax;
    }

    public void setStampTax(BigDecimal stampTax) {
        this.stampTax = stampTax;
    }
    public BigDecimal getFund() {
        return fund;
    }

    public void setFund(BigDecimal fund) {
        this.fund = fund;
    }
    public BigDecimal getPersonalIncomeTax() {
        return personalIncomeTax;
    }

    public void setPersonalIncomeTax(BigDecimal personalIncomeTax) {
        this.personalIncomeTax = personalIncomeTax;
    }
    public BigDecimal getCorporateIncomeTax() {
        return corporateIncomeTax;
    }

    public void setCorporateIncomeTax(BigDecimal corporateIncomeTax) {
        this.corporateIncomeTax = corporateIncomeTax;
    }
    public BigDecimal getWaterConstructionIncome() {
        return waterConstructionIncome;
    }

    public void setWaterConstructionIncome(BigDecimal waterConstructionIncome) {
        this.waterConstructionIncome = waterConstructionIncome;
    }
    public BigDecimal getEnvProtectionTax() {
        return envProtectionTax;
    }

    public void setEnvProtectionTax(BigDecimal envProtectionTax) {
        this.envProtectionTax = envProtectionTax;
    }
    public BigDecimal getWaterResources() {
        return waterResources;
    }

    public void setWaterResources(BigDecimal waterResources) {
        this.waterResources = waterResources;
    }
    public BigDecimal getOtherItems() {
        return otherItems;
    }

    public void setOtherItems(BigDecimal otherItems) {
        this.otherItems = otherItems;
    }
    public BigDecimal getAdditionalTaxTotal() {
        return additionalTaxTotal;
    }

    public void setAdditionalTaxTotal(BigDecimal additionalTaxTotal) {
        this.additionalTaxTotal = additionalTaxTotal;
    }
    public BigDecimal getTaxTotal() {
        return taxTotal;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }
    public Date getNationalTaxPaidDate() {
        return nationalTaxPaidDate;
    }

    public void setNationalTaxPaidDate(Date nationalTaxPaidDate) {
        this.nationalTaxPaidDate = nationalTaxPaidDate;
    }
    public String getNationalTaxPaymentCertNum() {
        return nationalTaxPaymentCertNum;
    }

    public void setNationalTaxPaymentCertNum(String nationalTaxPaymentCertNum) {
        this.nationalTaxPaymentCertNum = nationalTaxPaymentCertNum;
    }
    public String getNationalTaxPaymentOrgId() {
        return nationalTaxPaymentOrgId;
    }

    public void setNationalTaxPaymentOrgId(String nationalTaxPaymentOrgId) {
        this.nationalTaxPaymentOrgId = nationalTaxPaymentOrgId;
    }
    public String getNationalTaxPaymentOrgName() {
        return nationalTaxPaymentOrgName;
    }

    public void setNationalTaxPaymentOrgName(String nationalTaxPaymentOrgName) {
        this.nationalTaxPaymentOrgName = nationalTaxPaymentOrgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(Long sourceContractId) {
        this.sourceContractId = sourceContractId;
    }

    public String getSourceContractName() {
        return sourceContractName;
    }

    public void setSourceContractName(String sourceContractName) {
        this.sourceContractName = sourceContractName;
    }

    public BigDecimal getInvoiceNum() {
        return invoiceNum;
    }

    public void setInvoiceNum(BigDecimal invoiceNum) {
        this.invoiceNum = invoiceNum;
    }
}
