package com.ejianc.business.laborservice.service.impl;

import com.ejianc.business.laborservice.vo.LaborserviceProjectVO;
import com.ejianc.business.laborservice.vo.LaborserviceTeamVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.laborservice.mapper.LaborserviceTeamMapper;
import com.ejianc.business.laborservice.bean.LaborserviceTeamEntity;
import com.ejianc.business.laborservice.service.ILaborserviceTeamService;

import java.util.List;

/**
 * 劳务公司队伍管理
 * 
 * @author generator
 * 
 */
@Service("laborserviceTeamService")
public class LaborserviceTeamServiceImpl extends BaseServiceImpl<LaborserviceTeamMapper, LaborserviceTeamEntity> implements ILaborserviceTeamService{

    @Override
    public LaborserviceTeamVO getProjectInfoByTeamId(Long teamId) {
        LaborserviceTeamVO teamVO = null;
        LaborserviceTeamEntity laborserviceTeamEntity = baseMapper.selectById(teamId);
        if (laborserviceTeamEntity != null) {
            teamVO = BeanMapper.map(laborserviceTeamEntity, LaborserviceTeamVO.class);
            List<LaborserviceProjectVO> projectInfoByTeamId = baseMapper.getProjectInfoByTeamId(teamId);
            teamVO.setProjects(projectInfoByTeamId);
        }
        return teamVO;
    }
}
