package com.ejianc.business.laborservice.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.laborservice.bean.LaborserviceProjectEntity;
import com.ejianc.business.laborservice.service.ILaborserviceProjectService;
import com.ejianc.business.laborservice.utils.EJCDateUtil;
import com.ejianc.business.laborservice.vo.AreaDataVO;
import com.ejianc.business.laborservice.vo.InfoAreaVO;
import com.ejianc.business.laborservice.vo.LaborserviceProjectVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import static com.ejianc.business.laborservice.utils.AddressResolutionUtil.*;

/**
 * 劳务公司项目
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("laborserviceProject")
public class LaborserviceProjectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    //TODO 外部项目编码规则待确认，暂时使用默认编码，内部项目使用带过来的项目编码
    private static final String BILL_CODE = "劳务-项目信息管理";//此处需要根据实际修改

    //private static final String BILL_CODE ="Invoice_Open_Apply_Code";
    @Autowired
    private ILaborserviceProjectService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LaborserviceProjectVO> saveOrUpdate(@RequestBody LaborserviceProjectVO saveOrUpdateVO) {
    	LaborserviceProjectEntity entity = BeanMapper.map(saveOrUpdateVO, LaborserviceProjectEntity.class);
        UserContext userContextCache=sessionManager.getUserContext();
        if(entity.getId()==null||entity.getId()==0){
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam=BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode=billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()){
                //entity.setCode(billCode.getData());//此处需要根据实际修改删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改删除本行或者上一行
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }else{
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
    	service.saveOrUpdate(entity, false);
    	LaborserviceProjectVO vo = BeanMapper.map(entity, LaborserviceProjectVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LaborserviceProjectVO> queryDetail(Long id) {
    	LaborserviceProjectEntity entity = service.selectById(id);
    	LaborserviceProjectVO vo = BeanMapper.map(entity, LaborserviceProjectVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LaborserviceProjectVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (LaborserviceProjectVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(LaborserviceProjectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LaborserviceProjectVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("registCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            /*if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
            }*/
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<LaborserviceProjectEntity> page = service.queryPage(param,false);
        IPage<LaborserviceProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), LaborserviceProjectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LaborserviceProjectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborserviceProject-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLaborserviceProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LaborserviceProjectVO>> refLaborserviceProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");

        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        orderMap.put("createTime","desc");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (null!=_con.get("projectStatus")) {
                param.getParams().put("projectStatus", new Parameter(QueryParam.EQ, _con.getString("projectStatus")));
            }
        }

        IPage<LaborserviceProjectEntity> page = service.queryPage(param,false);
        IPage<LaborserviceProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LaborserviceProjectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @GetMapping("getIdByProjectId")
    @ResponseBody
    public CommonResponse<LaborserviceProjectVO> getIdByProjectId(@RequestParam("projectId") String projectId){
        LaborserviceProjectEntity entity = service.getIdByProjectId(projectId);
        if (entity!=null) {
            LaborserviceProjectVO projectVO = BeanMapper.map(entity, LaborserviceProjectVO.class);
            return CommonResponse.success("查询成功",projectVO);
        }else{
            return CommonResponse.error("未找到数据！");
        }
    }


    /**
     * 门户-项目地图
     *
     * @param name
     * @param dateIn
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/getInfoArea", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getInfoArea(@RequestParam(value = "name", required = false) String name,
                                                  @RequestParam(value = "dateIn", required = false) String dateIn,
                                                  @RequestParam(value = "orgId", required = false) Long orgId) {
        return this.infoArea(name, dateIn, orgId);
    }

    public CommonResponse<JSONObject> infoArea(String name, String dateIn, Long orgId) {
        //今年
        dateIn = EJCDateUtil.getYear() + "";


        QueryWrapper<LaborserviceProjectEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(dateIn)) {
            queryWrapper.eq("DATE_FORMAT(create_time,\"%Y\")", dateIn);
        }
        queryWrapper.in("bill_state", Arrays.asList(1, 3));
        List<LaborserviceProjectEntity> list = service.list(queryWrapper);

        List<InfoAreaVO> infoAreaVOS = new ArrayList<>();
        if (ListUtil.isNotEmpty(list)) {
            List<LaborserviceProjectVO> infoRegisterVOS = BeanMapper.mapList(list, LaborserviceProjectVO.class);
            for (LaborserviceProjectVO infoRegisterVO : infoRegisterVOS) {
                InfoAreaVO infoAreaVO = new InfoAreaVO();
                infoAreaVO.setId(infoRegisterVO.getId());
                infoAreaVO.setOrgId(infoRegisterVO.getOrgId());
                infoAreaVO.setCourtName(infoRegisterVO.getProjectName());
                if (StringUtils.isNotEmpty(infoRegisterVO.getAreaName())) {
                    String areaName = null;
                    areaName = infoRegisterVO.getAreaName().replace("/", "");
                    infoAreaVO.setAreaName(areaName);
                } else {
                    infoAreaVO.setAreaName(infoRegisterVO.getAreaName());
                }
                infoAreaVOS.add(infoAreaVO);
            }
        }
        List<Long> ids = new ArrayList<>();
        Set<String> provinceSet = new HashSet<>();
        Set<String> citySet = new HashSet<>();
        Set<String> countySet = new HashSet<>();
        String pname = null;
        for (InfoAreaVO vo : infoAreaVOS) {
            ids.add(vo.getId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(vo.getAreaName())) {
                if (vo.getAreaName().equals("台湾省")) {
                    vo.setProvince("台湾省");
                    vo.setCity("台湾省");
                    vo.setCounty("台湾省");

                    provinceSet.add("台湾省");
                    citySet.add("台湾省");
                    countySet.add("台湾省");
                } else {
                    Map<String, String> areaMap = addressResolution(vo.getAreaName());
                    if (areaMap != null) {
                        String province = areaMap.get("province") == null ? "其他" : areaMap.get("province");
                        String city = areaMap.get("city") == null ? "其他" : areaMap.get("city");
                        String county = areaMap.get("county") == null ? "其他" : areaMap.get("county");
                        vo.setProvince(province);
                        vo.setCity(city);
                        vo.setCounty(county);
                        provinceSet.add(province);
                        citySet.add(city);
                        countySet.add(county);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(name) && city.equals(name)) {
                            pname = province;
                        }
                    } else {
                        vo.setProvince("其他");
                        vo.setCity("其他");
                        vo.setCounty("其他");
                        provinceSet.add("其他");
                        citySet.add("其他");
                        countySet.add("其他");
                    }
                }
            } else {
                vo.setProvince("其他");
                vo.setCity("其他");
                vo.setCounty("其他");
                provinceSet.add("其他");
                citySet.add("其他");
                countySet.add("其他");
            }

        }

        String rangeType = null;
        List<AreaDataVO> dataVOS = new ArrayList<>();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(name)) {
            if (provinceSet.contains(name)) {// 如果选择省
                rangeType = getProvincePinYin(name);
                dataVOS = projectCountByName(name, infoAreaVOS, 0);
            } else if (citySet.contains(name)) {
                rangeType = getProvincePinYin(pname) + "-" + getNamePinYinChar(name, 1);
                dataVOS = projectCountByName(name, infoAreaVOS, 1);
            }

        } else {
            if (provinceSet.size() == 1) {//同一省份
                if (citySet.size() == 1) {// 如果是同一市
                    rangeType = getProvincePinYin(provinceSet.iterator().next()) + "-" + getNamePinYinChar(citySet.iterator().next(), 1);
                    Map<String, AreaDataVO> countyMap = new HashMap<>();
                    for (InfoAreaVO vo : infoAreaVOS) {
                        String county = vo.getCounty();
                        if (!countyMap.containsKey(county)) {
                            AreaDataVO pvo = new AreaDataVO();
                            pvo.setName(county);
                            pvo.setValue(1);
                            countyMap.put(county, pvo);
                        } else {
                            AreaDataVO projectDataVO = countyMap.get(county);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            countyMap.put(county, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<AreaDataVO>(countyMap.values());
                    Map<String, List<InfoAreaVO>> map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
                    for (AreaDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<InfoAreaVO> projectCountVOS = map.get(dataVO.getName());
                            dataVO.setInfoAreaVOS(projectCountVOS);
                        }
                    }
                } else {
                    rangeType = getProvincePinYin(provinceSet.iterator().next());
                    Map<String, AreaDataVO> cityMap = new HashMap<>();
                    for (InfoAreaVO vo : infoAreaVOS) {
                        String city = vo.getCity();
                        if (!cityMap.containsKey(city)) {
                            AreaDataVO pvo = new AreaDataVO();
                            pvo.setName(city);
                            pvo.setValue(1);
                            cityMap.put(city, pvo);
                        } else {
                            AreaDataVO projectDataVO = cityMap.get(city);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            cityMap.put(city, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<AreaDataVO>(cityMap.values());
                    Map<String, List<InfoAreaVO>> map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity));
                    for (AreaDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<InfoAreaVO> projectCountVOS = map.get(dataVO.getName());
                            dataVO.setInfoAreaVOS(projectCountVOS);
                        }
                    }
                }

            } else {//不同省份
                rangeType = "China";
                Map<String, AreaDataVO> provinceMap = new HashMap<>();
                for (InfoAreaVO vo : infoAreaVOS) {
                    String province = vo.getProvince();
                    if (!provinceMap.containsKey(province)) {
                        AreaDataVO pvo = new AreaDataVO();
                        pvo.setName(province);
                        pvo.setValue(1);
                        provinceMap.put(province, pvo);
                    } else {
                        AreaDataVO projectDataVO = provinceMap.get(province);
                        projectDataVO.setValue(projectDataVO.getValue() + 1);
                        provinceMap.put(province, projectDataVO);
                    }
                }
                Map<String, List<InfoAreaVO>> map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getProvince));
                dataVOS = new ArrayList<AreaDataVO>(provinceMap.values());
                for (AreaDataVO dataVO : dataVOS) {
                    if (map.containsKey(dataVO.getName())) {
                        List<InfoAreaVO> projectCountVOS = map.get(dataVO.getName());
                        dataVO.setInfoAreaVOS(projectCountVOS);
                    }
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<AreaDataVO>() {
                @Override
                public int compare(AreaDataVO o1, AreaDataVO o2) {
                    int a = "其他".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "其他".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        //在这个地方处理四个直辖市
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "beijing";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        if (rangeType == null || rangeType.contains("null")) {
            rangeType = "China";
        }
        jsonObject.put("range", rangeType == null || rangeType.contains("null") ? "China" : rangeType);
        List<AreaDataVO> projectDataVOS = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(dataVOS)) {
//            Map<String, AreaDataVO> map = dataVOS.stream().collect(Collectors.toMap(k -> k.getName(), (k) -> k));
//            if (rangeType.equals("China")) {
//                //河南的省 省内
//                if (map.containsKey("河南省")) {
//                    List<InfoAreaVO> projectList = new ArrayList<>();
//                    AreaDataVO vo = map.get("河南省");
//                    if (vo != null) {
//                        projectList.addAll(vo.getInfoAreaVOS());
//                    }
//                    List<Long> areaInfoIds = projectList.stream().map(InfoAreaVO::getId).collect(Collectors.toList());
//
//                    AreaDataVO projectDataVO = new AreaDataVO();
//                    projectDataVO.setCurrentProvince("河南省");
//                    projectDataVO.setName("省内");
//                    projectDataVO.setValue(areaInfoIds.size());
//                    projectDataVOS.add(projectDataVO);
//                }
//
//                //河南省的 省外 排除其他的
//                List<Long> projectIds = new ArrayList<>();
//                for (AreaDataVO dataVO : dataVOS) {
//                    if (!"其他".equals(dataVO.getName()) && !"河南省".equals(dataVO.getName())) {
//                        List<Long> pids = dataVO.getInfoAreaVOS().stream().map(InfoAreaVO::getId).collect(Collectors.toList());
//                        projectIds.addAll(pids);
//                    }
//                }
//
//                AreaDataVO projectDataVO = new AreaDataVO();
//                projectDataVO.setName("省外");
//                projectDataVO.setValue(projectIds.size());
//                projectDataVOS.add(projectDataVO);
//                jsonObject.put("data", projectDataVOS);
//                return CommonResponse.success("查询数据成功！", jsonObject);
//            }
//        }
        jsonObject.put("data", dataVOS);
        return CommonResponse.success("查询数据成功！", jsonObject);
    }

    private List<AreaDataVO> projectCountByName(String name, List<InfoAreaVO> list, Integer type) {
        List<AreaDataVO> dataVOS = new ArrayList<>();
        Map<String, AreaDataVO> map = new HashMap<>();
        for (InfoAreaVO vo : list) {
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (voName.equals(name)) {
                if (!map.containsKey(childrenName)) {
                    AreaDataVO pvo = new AreaDataVO();
                    pvo.setName(childrenName);
                    pvo.setValue(1);
                    map.put(childrenName, pvo);
                } else {
                    AreaDataVO projectDataVO = map.get(childrenName);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    map.put(childrenName, projectDataVO);
                }
            }
        }
        Map<String, List<InfoAreaVO>> projectCountVOMap = null;
        if (type == 0) {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity));
        } else {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
        }
        ArrayList<AreaDataVO> projectDataVOS = new ArrayList<>(map.values());
        for (AreaDataVO dataVO : projectDataVOS) {
            if (map.containsKey(dataVO.getName())) {
                List<InfoAreaVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
                dataVO.setInfoAreaVOS(projectCountVOS);
            }
        }
        return projectDataVOS;

    }
}
