package com.ejianc.business.laborservice.mapper;

import com.ejianc.business.laborservice.vo.LaborserviceExpendContractVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.laborservice.bean.LaborserviceExpendContractEntity;
import org.apache.ibatis.annotations.Select;

/**
 * 劳务公司支出合同
 * 
 * @author generator
 * 
 */
@Mapper
public interface LaborserviceExpendContractMapper extends BaseCrudMapper<LaborserviceExpendContractEntity> {

   /* @Select ({
            "select management_rate from zzyj_laborservice_expend_contract where income_contract_id=#{incomeContractId} "
    })
    Decimal getManagementRate(String incomeContractId);*/

    @Select("SELECT COUNT(*) as num , IFNULL(SUM(contract_accumulate_tax),0) as contract_accumulate_tax FROM `zzyj_laborservice_expend_contract`\n" +
            "where dr = 0 and bill_state in (1,3) and YEAR(sign_date) = YEAR(NOW()) ")
   LaborserviceExpendContractVO getThisYearExpendData();

    @Select("SELECT COUNT(*) as num , IFNULL(SUM(contract_accumulate_tax),0) as contract_accumulate_tax , #{year} as year FROM `zzyj_laborservice_income_contract`\n" +
            "where dr = 0 and bill_state in (1,3) and YEAR(sign_date) = #{year} ")
   LaborserviceExpendContractVO getThisYearIncomeData( Integer year);

    @Select("SELECT COUNT(*) as num , IFNULL(SUM(amount_including_tax),0) as contract_accumulate_tax FROM `zzyj_laborservice_invoice_info`\n" +
            "where dr = 0 and bill_state in (1,3) and YEAR(invoicing_date) = YEAR(NOW()) ")
   LaborserviceExpendContractVO getThisYearInvoiceData();

    @Select("SELECT COUNT(*) as num , IFNULL(SUM(contract_accumulate_tax),0) as contract_accumulate_tax , #{year} as year,#{contractType} as contract_type FROM `zzyj_laborservice_income_contract`\n" +
            "where dr = 0 and bill_state in (1,3) and YEAR(sign_date) = #{year} and contract_type = #{contractType}")
    LaborserviceExpendContractVO getLastYearIncomeData( Integer year,String contractType);

    @Select("SELECT COUNT(*) as num , IFNULL(SUM(contract_accumulate_tax),0) as contract_accumulate_tax , #{year} as year FROM `zzyj_laborservice_expend_contract`\n" +
            "where dr = 0 and bill_state in (1,3) and YEAR(sign_date) = #{year} ")
    LaborserviceExpendContractVO getLastYearExpendData( Integer year);

    //收入合同变更金额、数量
    @Select("SELECT COUNT(*) as num , IFNULL(SUM(this_change_tax_mny),0) as contract_accumulate_tax , #{year} as year FROM `zzyj_laborservice_income_contract_change`\n" +
            "            where dr = 0 and bill_state in (1,3) and YEAR(sign_date) = #{year} ")
    LaborserviceExpendContractVO getIncomeChangeData( Integer year);

    //收入合同未签支出合同金额、数量
    @Select("SELECT COUNT(*) as num , IFNULL(SUM(contract_accumulate_tax),0) as contract_accumulate_tax , #{year} as year FROM `zzyj_laborservice_income_contract`\n" +
            "where dr = 0 and bill_state in (1,3) and YEAR(sign_date) = #{year} and is_sign_expend_contract = 0")
    LaborserviceExpendContractVO getIncomeNoExpendData( Integer year);



}
