package com.ejianc.business.laborservice.utils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddressResolutionUtil {
    public static Map<String, String> addressResolution(String address) {
        String regex = "(?<province>[^省]+自治区|.*?省|.*?行政区|.*?市)(?<city>[^市]+自治州|.*?地区|.*?行政单位|.+盟|市辖区|.*?市|.*?县|.*?区)(?<county>[^县]+县|[^区]+区|[^市]+市|[^旗]+旗|.+海域|[^岛]+岛)?(?<town>[^区]+区|.+镇)?(?<village>.*)";
        Matcher m = Pattern.compile(regex).matcher(address);
        String province = null, city = null, county = null, town = null, village = null;
        List<Map<String, String>> table = new ArrayList<Map<String, String>>();
        Map<String, String> row = null;
        while (m.find()) {
            row = new LinkedHashMap<String, String>();
            province = m.group("province");
            row.put("province", province == null ? "" : province.trim());
            city = m.group("city");
            row.put("city", city == null ? "" : city.trim());
            county=m.group("county");
            row.put("county", county==null?"":county.trim());
//            town=m.group("town");
//            row.put("town", town==null?"":town.trim());
//            village=m.group("village");
//            row.put("village", village==null?"":village.trim());
            table.add(row);
        }
        return row;
    }

    public static void main(String[] args) {
        //Map<String, String> list = addressResolution("河北省石家庄市裕华区长江街道黄河大道");
        String str="北京市/市辖区/东城区";
        String replace = str.replace("/", "");
        System.out.println(replace);
        Map<String, String> list = addressResolution(replace);

        System.out.println(list);
//
//        System.out.println(getNamePinYinChar("湖北省武汉市洪山区",1));
//        System.out.println(addressResolution("湖北省恩施土家族苗族自治州恩施市"));
//        System.out.println(addressResolution("北京市市辖区朝阳区"));
//        System.out.println(addressResolution("内蒙古自治区兴安盟科尔沁右翼前旗"));
//        System.out.println(addressResolution("西藏自治区日喀则地区日喀则市"));
//        System.out.println(addressResolution("海南省省直辖县级行政单位中沙群岛的岛礁及其海域"));
    }

    public static String getProvincePinYin(String province) {
        String pinYin = null;
        switch (province) {
            case "安徽省":
                pinYin = "anhui";
                break;
            case "澳门特别行政区":
                pinYin = "aomen";
                break;
            case "北京市":
                pinYin = "beijing";
                break;
            case "重庆市":
                pinYin = "chongqing";
                break;
            case "福建省":
                pinYin = "fujian";
                break;
            case "甘肃省":
                pinYin = "gansu";
                break;
            case "广东省":
                pinYin = "guangdong";
                break;
            case "广西壮族自治区":
                pinYin = "guangxi";
                break;
            case "贵州省":
                pinYin = "guizhou";
                break;
            case "海南省":
                pinYin = "hainan";
                break;
            case "河北省":
                pinYin = "hebei";
                break;
            case "黑龙江省":
                pinYin = "heilongjiang";
                break;
            case "河南省":
                pinYin = "henan";
                break;
            case "湖北省":
                pinYin = "hubei";
                break;
            case "湖南省":
                pinYin = "hunan";
                break;
            case "江苏省":
                pinYin = "jiangsu";
                break;
            case "江西省":
                pinYin = "jiagnxi";
                break;
            case "吉林省":
                pinYin = "jilin";
                break;
            case "辽宁省":
                pinYin = "liaoning";
                break;
            case "内蒙古自治区":
                pinYin = "neimenggu";
                break;
            case "宁夏回族自治区":
                pinYin = "ningxiahuizu";
                break;
            case "青海省":
                pinYin = "qinghai";
                break;
            case "山东省":
                pinYin = "shandong";
                break;
            case "上海市":
                pinYin = "shanghai";
                break;
            case "陕西省":
                pinYin = "shanxi";
                break;
            case "山西省":
                pinYin = "shanxi2";
                break;
            case "四川省":
                pinYin = "sichuan";
                break;
            case "天津市":
                pinYin = "tianjin";
                break;
            case "香港特别行政区":
                pinYin = "xianggang";
                break;
            case "新疆维吾尔自治区":
                pinYin = "xinjiangweiwuer";
                break;
            case "西藏自治区":
                pinYin = "xizang";
                break;
            case "云南省":
                pinYin = "yunnan";
                break;
            case "浙江省":
                pinYin = "zhejiang";
                break;
            case "台湾省":
                pinYin = "taiwan";
                break;
            default:
                break;
        }
        return pinYin;
    }

    /**
     * 获取姓名拼音
     *
     * @param zn_str   姓名
     * @param caseType 1-小写，2-大写
     * @return
     */
    public static String getNamePinYinChar(String zn_str, int caseType) {

        if (zn_str != null && !zn_str.trim().equalsIgnoreCase("")) {
            char[] strChar = zn_str.toCharArray();
            // 汉语拼音格式输出类
            HanyuPinyinOutputFormat hanYuPinOutputFormat = new HanyuPinyinOutputFormat();
            // 输出设置，大小写，音标方式等
            if (1 == caseType) {
                hanYuPinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            } else {
                hanYuPinOutputFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
            }
            hanYuPinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            hanYuPinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
            StringBuffer pyStringBuffer = new StringBuffer();
            for (int i = 0; i < strChar.length; i++) {
                char c = strChar[i];
                if (Character.isWhitespace(c)) {// 如果是空格则跳过
                    continue;
                }
                //char pyc = strChar[i];
                if (isHanZi(c)) {// 是中文或者a-z或者A-Z转换拼音
                    try {

                        String[] pyStirngArray = PinyinHelper.toHanyuPinyinStringArray(strChar[i],
                                hanYuPinOutputFormat);
                        if (null != pyStirngArray && pyStirngArray[0] != null) {
                            pyStringBuffer.append(pyStirngArray[0]);
                        }

                    } catch (BadHanyuPinyinOutputFormatCombination e) {
                        e.printStackTrace();
                    }
                } else {
                    // 不是汉字
                    if (isEnglish(c)) {// 第一个属于字母，则返回该字母
                        if (1 == caseType) {
                            pyStringBuffer.append(String.valueOf(c).toLowerCase(Locale.ENGLISH));
                        } else {
                            pyStringBuffer.append(String.valueOf(c).toUpperCase(Locale.ENGLISH));
                        }
                    } else if (Character.isDigit(c)) {
                        if (i == 0) {
                            pyStringBuffer.append("#");// 不是的话返回#号
                        }
                        pyStringBuffer.append(c);
                    } else if (i == 0) {
                        pyStringBuffer.append("#");// 不是的话返回#号
                    }
                }
            }

            return pyStringBuffer.toString();
        }
        return null;
    }

    //判断是不是汉字
    public static boolean isHanZi(char c) {
        Pattern pattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
        Matcher matcher = pattern.matcher(String.valueOf(c));
        return matcher.matches();
    }

    //判断是不是英文
    public static boolean isEnglish(char c) {
        return String.valueOf(c).matches("^[a-zA-Z]*");
    }
}
