package com.ejianc.business.oa.controller;

import java.io.Serializable;

import com.ejianc.business.oa.mapper.ExpenseClaimMapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.oa.bean.ExpenseClaimEntity;
import com.ejianc.business.oa.service.IExpenseClaimService;
import com.ejianc.business.oa.vo.ExpenseClaimVO;

/**
 * 费用支出申请表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("expenseClaim")
public class ExpenseClaimController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FYZC";//此处需要根据实际修改

    @Autowired
    private IExpenseClaimService service;
    @Autowired
    private ExpenseClaimMapper mapper;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExpenseClaimVO> saveOrUpdate(@RequestBody ExpenseClaimVO saveOrUpdateVO) {
    	ExpenseClaimEntity entity = BeanMapper.map(saveOrUpdateVO, ExpenseClaimEntity.class);
        UserContext userContextCache=sessionManager.getUserContext();
        if(entity.getId()==null||entity.getId()==0){
            //设置创建人姓名  
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam=BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String>billCode=billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()){
                //entity.setCode(billCode.getData());//此处需要根据实际修改删除本行或者下一行  
                entity.setBillCode(billCode.getData());//此处需要根据实际修改删除本行或者上一行  
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }else{
            //设置修改人姓名  
            entity.setUpdateUserName(userContextCache.getUserName());
        }
    	service.saveOrUpdate(entity, false);
    	ExpenseClaimVO vo = BeanMapper.map(entity, ExpenseClaimVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExpenseClaimVO> queryDetail(Long id) {
    	ExpenseClaimEntity entity = service.selectById(id);
    	ExpenseClaimVO vo = BeanMapper.map(entity, ExpenseClaimVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExpenseClaimVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ExpenseClaimVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ExpenseClaimVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExpenseClaimVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("projectInfo");
        fuzzyFields.add("expendType");
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ExpenseClaimEntity> page = service.queryPage(param,false);
        IPage<ExpenseClaimVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpenseClaimVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("projectInfo");
        fuzzyFields.add("expendType");
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExpenseClaimEntity> list = service.queryList(param);
        //todo:字段翻译等等
        if (CollectionUtils.isNotEmpty(list)){
            for (ExpenseClaimEntity record : list) {
                if (record.getIsReport() == 1) {
                    record.setUpdateUserName("是");
                } else {
                    record.setUpdateUserName("否");
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ExpenseClaim-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refExpenseClaimData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExpenseClaimVO>> refExpenseClaimData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ExpenseClaimEntity> page = service.queryPage(param,false);
        IPage<ExpenseClaimVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpenseClaimVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description queryDetail 查询详情
     * @param
     */
    @RequestMapping(value = "/queryOrgMonthMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryOrgMonthMny(Long orgId, Date month, String type) {
        BigDecimal bigDecimal = mapper.queryOrgMonthMny(orgId, month, type);
        return CommonResponse.success("查询详情数据成功！",bigDecimal);
    }
}
