/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.laborservice.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.laborservice.bean.OutboundEntity;
import com.ejianc.business.laborservice.mapper.OutboundMapper;
import com.ejianc.business.laborservice.service.IOutboundService;
import com.ejianc.business.laborservice.vo.OutboundVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"outbound"})
public class OutboundController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private OutboundMapper outboundMapper;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IOutboundService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OutboundVO> saveOrUpdate(@RequestBody OutboundVO saveOrUpdateVO) {
        OutboundEntity entity = (OutboundEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutboundEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OutboundVO vo = (OutboundVO)BeanMapper.map((Object)((Object)entity), OutboundVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutboundVO> queryDetail(Long id) {
        OutboundEntity entity = (OutboundEntity)((Object)this.service.selectById(id));
        OutboundVO vo = (OutboundVO)BeanMapper.map((Object)((Object)entity), OutboundVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutboundVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OutboundVO outboundVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutboundVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("expendContractName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectAddress");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("byNumber");
        fuzzyFields.add("outboundStatus");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutboundVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("expendContractName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectAddress");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("byNumber");
        fuzzyFields.add("outboundStatus");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Outbound-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOutboundData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutboundVO>> refOutboundData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutboundVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySumMnyByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> querySumMnyByContractId(Long id) {
        BigDecimal bigDecimal = this.outboundMapper.querySumMnyByContractId(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u7d2f\u8ba1\u5f00\u7968\u91d1\u989d\u6210\u529f\uff01", (Object)bigDecimal);
    }

    @RequestMapping(value={"/queryCategory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryCategory(@RequestParam(value="expendId") Long expendId) {
        ArrayList<JSONObject> listReturn;
        QueryParam param = new QueryParam();
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("expendContractId", new Parameter("eq", (Object)expendId));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        List outboundEntities = this.service.queryList(param);
        JSONObject jsonObjectReturn = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)outboundEntities)) {
            listReturn = new ArrayList<JSONObject>();
            for (OutboundEntity outboundEntity : outboundEntities) {
                JSONObject o = new JSONObject();
                o.put("text", (Object)outboundEntity.getByNumber());
                o.put("value", (Object)outboundEntity.getByNumber());
                listReturn.add(o);
            }
        } else {
            jsonObjectReturn.put("data", null);
            return CommonResponse.success((Object)jsonObjectReturn);
        }
        jsonObjectReturn.put("data", listReturn);
        return CommonResponse.success((Object)jsonObjectReturn);
    }
}

