package com.ejianc.business.laborservice.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractEntity;
import com.ejianc.business.laborservice.bean.LaborserviceInvoiceApplyEntity;
import com.ejianc.business.laborservice.bean.LaborserviceInvoiceInfoEntity;
import com.ejianc.business.laborservice.mapper.LaborserviceIncomeContractMapper;
import com.ejianc.business.laborservice.mapper.LaborserviceInvoiceApplyMapper;
import com.ejianc.business.laborservice.service.ILaborserviceInvoiceInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;

@Service("laborserviceInvoiceInfo") 
public class LaborserviceInvoiceInfoBpmServiceImpl implements ICommonBusinessService {
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		updateAccumulateInvoicedAmountById(billId,true);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		updateAccumulateInvoicedAmountById(billId,false);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	@Autowired
	private ILaborserviceInvoiceInfoService service;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private LaborserviceIncomeContractMapper incomeContractMapper;

	//根据开票合同id查询收入合同，并更新累计开票额度
	public void updateAccumulateInvoicedAmountById(Long billId,boolean addFlag){
		LaborserviceInvoiceInfoEntity laborserviceInvoiceInfoEntity = service.selectById(billId);
		BigDecimal amountIncludingTax = laborserviceInvoiceInfoEntity.getAmountIncludingTax(); //本次开票amount_including_tax
		if(laborserviceInvoiceInfoEntity.getIncomeContractId() != null){
			LaborserviceIncomeContractEntity incomeContractEntity = incomeContractMapper.selectById(laborserviceInvoiceInfoEntity.getIncomeContractId());
			logger.info("id:"+incomeContractEntity.getId()+":原累计开票数："+incomeContractEntity.getAccumulateInvoicedAmount()+",本次开票数："+amountIncludingTax);
			if (ObjectUtil.isNotEmpty(amountIncludingTax)) {
				BigDecimal accumulateInvoicedAmount = incomeContractEntity.getAccumulateInvoicedAmount();
				if (ObjectUtil.isEmpty(accumulateInvoicedAmount)) {
					accumulateInvoicedAmount = new BigDecimal(0);
				}

				BigDecimal newAmount = BigDecimal.ZERO;
				if(addFlag){
					newAmount = accumulateInvoicedAmount.add(amountIncludingTax);
				}else{
					newAmount = accumulateInvoicedAmount.subtract(amountIncludingTax);
				}
				incomeContractEntity.setAccumulateInvoicedAmount(newAmount);
				incomeContractMapper.updateById(incomeContractEntity);
				logger.info("更新累计开票数值："+incomeContractEntity.getAccumulateInvoicedAmount());
			}
		}

	}

}
