/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.itax.service.impl;

import com.ejianc.business.itax.bean.SalaryCollectDetailEntity;
import com.ejianc.business.itax.bean.SalaryCollectEntity;
import com.ejianc.business.itax.bean.SalaryEntity;
import com.ejianc.business.itax.bean.WorkerEntity;
import com.ejianc.business.itax.mapper.SalaryCollectMapper;
import com.ejianc.business.itax.service.ISalaryCollectDetailService;
import com.ejianc.business.itax.service.ISalaryCollectService;
import com.ejianc.business.itax.service.ISalaryDetailService;
import com.ejianc.business.laborservice.bean.ExpendApplyEntity;
import com.ejianc.business.laborservice.bean.LaborserviceExpendContractEntity;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeContractEntity;
import com.ejianc.business.laborservice.bean.LaborserviceIncomeReceivingEntity;
import com.ejianc.business.laborservice.service.IExpendApplyService;
import com.ejianc.business.laborservice.service.ILaborserviceExpendContractService;
import com.ejianc.business.laborservice.service.ILaborserviceIncomeContractService;
import com.ejianc.business.laborservice.service.ILaborserviceIncomeReceivingService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="salaryCollectService")
public class SalaryCollectServiceImpl
extends BaseServiceImpl<SalaryCollectMapper, SalaryCollectEntity>
implements ISalaryCollectService {
    @Autowired
    private ISalaryDetailService salaryDetailService;
    @Autowired
    private ISalaryCollectDetailService collectDetailService;
    @Autowired
    private SalaryCollectMapper salaryCollectMapper;
    @Autowired
    private ILaborserviceExpendContractService expendContractService;
    @Autowired
    private ILaborserviceIncomeContractService incomeContractService;
    @Autowired
    private IExpendApplyService expendApplyService;
    @Autowired
    private ILaborserviceIncomeReceivingService incomeReceivingService;

    @Override
    public SalaryCollectEntity calculateCollectItax(SalaryCollectEntity salaryEntity) {
        Date billTime = salaryEntity.getBillTime();
        List<SalaryCollectDetailEntity> salaryCollectDetailEntities = ((SalaryCollectMapper)this.baseMapper).calculateCollectItax(billTime);
        if (CollectionUtils.isNotEmpty(salaryCollectDetailEntities)) {
            for (SalaryCollectDetailEntity salaryCollectDetailEntity : salaryCollectDetailEntities) {
                salaryCollectDetailEntity.setPid(salaryEntity.getId());
                BigDecimal bigDecimal = salaryCollectDetailEntity.getThisYearIncome().add(salaryCollectDetailEntity.getLastMonthWsbIncome()).add(salaryCollectDetailEntity.getThisMonthDlffje()).subtract(salaryCollectDetailEntity.getExpenseReduction()).subtract(salaryCollectDetailEntity.getSpecialDeduction()).setScale(4, RoundingMode.HALF_UP);
                if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    salaryCollectDetailEntity.setThisMonthIncomeItax(bigDecimal);
                    salaryCollectDetailEntity.setThisMonthItax(this.salaryDetailService.calculate(bigDecimal));
                    continue;
                }
                salaryCollectDetailEntity.setThisMonthIncomeItax(BigDecimal.ZERO);
                salaryCollectDetailEntity.setThisMonthItax(BigDecimal.ZERO);
            }
            this.collectDetailService.saveOrUpdateBatch(salaryCollectDetailEntities);
            this.salaryCollectMapper.updateSbState(billTime, "\u5df2\u7533\u62a5");
            List<SalaryEntity> salaryListByTime = this.salaryCollectMapper.getSalaryListByTime(billTime);
            for (SalaryEntity entity : salaryListByTime) {
                BigDecimal bigDecimal = this.salaryCollectMapper.paySalaryMoney(entity.getId());
                LaborserviceExpendContractEntity laborserviceExpendContractEntity = (LaborserviceExpendContractEntity)((Object)this.expendContractService.selectById(entity.getExpendContractId()));
                if ("\u7532\u65b9\u603b\u5305\u4ee3\u53d1".equals(entity.getPayType())) {
                    LaborserviceIncomeContractEntity laborserviceIncomeContractEntity = (LaborserviceIncomeContractEntity)((Object)this.incomeContractService.selectById(laborserviceExpendContractEntity.getIncomeContractId()));
                    LaborserviceIncomeReceivingEntity laborserviceIncomeReceivingEntity = new LaborserviceIncomeReceivingEntity();
                    laborserviceIncomeReceivingEntity.setBillCode(entity.getBillCode());
                    laborserviceIncomeReceivingEntity.setIncomeContractId(laborserviceIncomeContractEntity.getId());
                    laborserviceIncomeReceivingEntity.setIncomeContractCode(laborserviceIncomeContractEntity.getBillCode());
                    laborserviceIncomeReceivingEntity.setIncomeContractName(laborserviceIncomeContractEntity.getContractName());
                    laborserviceIncomeReceivingEntity.setContractAccumulateTaxMny(laborserviceIncomeContractEntity.getContractAccumulateTaxMny());
                    laborserviceIncomeReceivingEntity.setContractStatus(laborserviceIncomeContractEntity.getContractStatus());
                    laborserviceIncomeReceivingEntity.setOrgId(laborserviceIncomeContractEntity.getOrgId());
                    laborserviceIncomeReceivingEntity.setOrgName(laborserviceIncomeContractEntity.getOrgName());
                    laborserviceIncomeReceivingEntity.setProjectId(laborserviceIncomeContractEntity.getProjectId());
                    laborserviceIncomeReceivingEntity.setProjectName(laborserviceIncomeContractEntity.getProjectName());
                    laborserviceIncomeReceivingEntity.setFirstPartyId(laborserviceIncomeContractEntity.getFirstPartyId());
                    laborserviceIncomeReceivingEntity.setFirstPartyName(laborserviceIncomeContractEntity.getFirstPartyName());
                    laborserviceIncomeReceivingEntity.setSupplierSignerId(laborserviceIncomeContractEntity.getSupplierSignerId());
                    laborserviceIncomeReceivingEntity.setSupplierSignerName(laborserviceIncomeContractEntity.getSupplierSignerName());
                    laborserviceIncomeReceivingEntity.setLaborIdcard(laborserviceIncomeContractEntity.getSupplierSignerCertId());
                    laborserviceIncomeReceivingEntity.setReceiveType("\u7532\u65b9\u603b\u5305\u4ee3\u53d1");
                    laborserviceIncomeReceivingEntity.setBillSource("\u81ea\u52a8\u751f\u6210");
                    laborserviceIncomeReceivingEntity.setBillSourceId(entity.getId() + "");
                    laborserviceIncomeReceivingEntity.setBillState(1);
                    laborserviceIncomeReceivingEntity.setReceivingAmount(bigDecimal);
                    this.incomeReceivingService.save((Object)laborserviceIncomeReceivingEntity);
                }
                ExpendApplyEntity laborserviceIncomeReceivingEntity = new ExpendApplyEntity();
                laborserviceIncomeReceivingEntity.setBillCode(entity.getBillCode());
                laborserviceIncomeReceivingEntity.setIncomeContractId(laborserviceExpendContractEntity.getId());
                laborserviceIncomeReceivingEntity.setIncomeContractCode(laborserviceExpendContractEntity.getBillCode());
                laborserviceIncomeReceivingEntity.setIncomeContractName(laborserviceExpendContractEntity.getContractName());
                laborserviceIncomeReceivingEntity.setContractAccumulateTaxMny(laborserviceExpendContractEntity.getContractAccumulateTax());
                laborserviceIncomeReceivingEntity.setContractStatus(laborserviceExpendContractEntity.getContractStatus());
                laborserviceIncomeReceivingEntity.setOrgId(laborserviceExpendContractEntity.getOrgId());
                laborserviceIncomeReceivingEntity.setOrgName(laborserviceExpendContractEntity.getOrgName());
                laborserviceIncomeReceivingEntity.setProjectId(laborserviceExpendContractEntity.getProjectId());
                laborserviceIncomeReceivingEntity.setProjectName(laborserviceExpendContractEntity.getProjectName());
                laborserviceIncomeReceivingEntity.setFirstPartyId(laborserviceExpendContractEntity.getFirstPartyId());
                laborserviceIncomeReceivingEntity.setFirstPartyName(laborserviceExpendContractEntity.getFirstPartyName());
                laborserviceIncomeReceivingEntity.setSupplierSignerName(laborserviceExpendContractEntity.getSupplier());
                laborserviceIncomeReceivingEntity.setLaborIdcard(laborserviceExpendContractEntity.getSupplierSignerCertId());
                laborserviceIncomeReceivingEntity.setExpendType(entity.getPayType());
                laborserviceIncomeReceivingEntity.setBillSource("\u81ea\u52a8\u751f\u6210");
                laborserviceIncomeReceivingEntity.setBillSourceId(entity.getId() + "");
                laborserviceIncomeReceivingEntity.setBillState(1);
                laborserviceIncomeReceivingEntity.setExpendAmount(bigDecimal);
                this.expendApplyService.save((Object)laborserviceIncomeReceivingEntity);
            }
        }
        return salaryEntity;
    }

    @Override
    public List<WorkerEntity> getWsb3Month(Date billTime) {
        return ((SalaryCollectMapper)this.baseMapper).getWsb3Month(billTime);
    }

    @Override
    public List<WorkerEntity> getWsbThisMonth(Date billTime) {
        return ((SalaryCollectMapper)this.baseMapper).getWsbThisMonth(billTime);
    }
}

