package com.ejianc.business.outputvalcount.service.impl;

import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.mapper.MonthlyStatisticsMapper;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 月度产值统计
 *
 * @author generator
 */
@Service("monthlyStatisticsService")
public class MonthlyStatisticsServiceImpl extends BaseServiceImpl<MonthlyStatisticsMapper, MonthlyStatisticsEntity> implements IMonthlyStatisticsService {


    @Autowired
    private MonthlyStatisticsMapper mapper;

    @Override
    public BigDecimal getSumMny(Long id) {
        return mapper.getSumMny(id);
    }

    @Override
    public MonthlyStatisticsEntity getMonthlyStatistics(MonthlyStatisticsEntity monthlyStatisticsEntity) {
        //获取当前项目的所有单据
        List<MonthlyStatisticsEntity> monthlyStatistics = mapper.getMonthlyStatistics(monthlyStatisticsEntity.getProjectId());
        int year = monthlyStatisticsEntity.getYear();
        int month = monthlyStatisticsEntity.getMonth();
        BigDecimal kgwccz = new BigDecimal(0);//开工累计金额
        BigDecimal bnwccz = new BigDecimal(0);//年初累计金额
        for(MonthlyStatisticsEntity entity : monthlyStatistics){
            if (entity.getYear() < year ||(entity.getYear() == year && entity.getMonth() < month ) ){
               if(entity.getBillState() != 1 && entity.getBillState() != 3){
                   throw new BusinessException(entity.getYear()+"年"+entity.getMonth()+"月份的单据未提交或未审批通过！");
               }

                kgwccz = kgwccz.add(entity.getBywccz());

                if (entity.getYear() == year && entity.getMonth() < month){
                    bnwccz = bnwccz.add(entity.getBywccz());
                }
            }
            if (entity.getYear() == year && entity.getMonth() == month  ){
                throw new BusinessException(entity.getYear()+"年"+entity.getMonth()+"月份的单据已存在！");
            }
        }
        kgwccz = kgwccz.add(monthlyStatisticsEntity.getBywccz());
        bnwccz = bnwccz.add(monthlyStatisticsEntity.getBywccz());
        monthlyStatisticsEntity.setKgwccz(kgwccz);
        monthlyStatisticsEntity.setBnwccz(bnwccz);
        return monthlyStatisticsEntity;
    }
}
