package com.ejianc.business.outputvalcount.api;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.mapper.MonthlyStatisticsMapper;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.business.outputvalcount.vo.OutputValueVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/outputValue/")
public class OutputValueApi {

    @Autowired
    private MonthlyStatisticsMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;


    @RequestMapping(value = "getSumByProjectId", method= RequestMethod.GET)
    CommonResponse<OutputValueVO> getSumByProjectId(@RequestParam Long projectId){
        //获取当前项目的所有单据
        List<MonthlyStatisticsEntity> monthlyStatistics = mapper.getMonthlyStatistics(projectId);
        BigDecimal sum = new BigDecimal(0);//开工累计金额

        for(MonthlyStatisticsEntity entity : monthlyStatistics){
            if(entity.getBillState() == 1 || entity.getBillState() == 3){
                sum = sum.add(entity.getBywccz());
            }
        }
        OutputValueVO outputValueVO = new OutputValueVO();

        CommonResponse<OrgVO> oneById = iOrgApi.getOneById(projectId);
        if(oneById.getCode()==0){
            OrgVO data = oneById.getData();
            outputValueVO.setProjectName(data.getName());
        }
        outputValueVO.setProjectId(projectId);
        outputValueVO.setSum(sum);
        return CommonResponse.success("获取数据成功！",outputValueVO);
    }

}
