/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputvalcount.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.mapper.MonthlyStatisticsMapper;
import com.ejianc.business.outputvalcount.service.IXmyxglService;
import com.ejianc.business.outputvalcount.vo.OutputValueVO;
import com.ejianc.business.outputvalcount.vo.XmyxglVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/outputValue/"})
public class OutputValueApi {
    @Autowired
    private MonthlyStatisticsMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IXmyxglService service;

    @RequestMapping(value={"getSumByProjectId"}, method={RequestMethod.GET})
    CommonResponse<OutputValueVO> getSumByProjectId(@RequestParam(value="projectId") Long projectId) {
        List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getMonthlyStatistics(projectId);
        BigDecimal sum = new BigDecimal(0);
        for (MonthlyStatisticsEntity entity : monthlyStatistics) {
            if (entity.getBillState() != 1 && entity.getBillState() != 3) continue;
            sum = sum.add(entity.getBywccz());
        }
        OutputValueVO outputValueVO = new OutputValueVO();
        CommonResponse oneById = this.iOrgApi.getOneById(projectId);
        if (oneById.getCode() == 0) {
            OrgVO data = (OrgVO)oneById.getData();
            outputValueVO.setProjectName(data.getName());
        }
        outputValueVO.setProjectId(projectId);
        outputValueVO.setSum(sum);
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)outputValueVO);
    }

    @RequestMapping(value={"getInfoByProjectId"}, method={RequestMethod.GET})
    CommonResponse<List<XmyxglVO>> getInfoByProjectId(@RequestParam(value="projectId") Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("xmId", new Parameter("eq", (Object)projectId));
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        queryParam.getParams().put("billState", new Parameter("in", billStates));
        queryParam.getParams().put("syxs", new Parameter("eq", (Object)2));
        IPage xmyxglEntityIPage = this.service.queryPage(queryParam, false);
        List xmyxglVOS = BeanMapper.mapList((Iterable)xmyxglEntityIPage.getRecords(), XmyxglVO.class);
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)xmyxglVOS);
    }
}

