package com.ejianc.business.outputvalcount.controller.warn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2022/6/6 11:22
 */
@RestController
@RequestMapping(value = "/warn/")
public class OutputValueWarnController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IMonthlyStatisticsService statisticsService;

    //业务数据前端详情页地址
    private static final String PC_URL = "/ejc-prosub-frontend/#/contract/cards?id=";

    /**
     * 预警服务
     *
     * @param jsonParam
     *      jsonParam {
     *          ignoreTenantIds: 忽略租户列表
     *          billParams：预警参数列表，
     *          defaultParam：{ 预警默认设置
     *              warnLevel：预警等级
     *              tenantId：租户Id
     *              warnSetId：预警设置Id
     *              earlywarnName：预警设置名称
     *              earlywarnContent：预警设置内容模板
     *              parameters：[ 默认预警参数
     *                {
     *                    name: 参数名称，
     *                    property：参数属性
     *                    type：参数类型
     *                    value：参数值
     *                    unit：参数单位
     *                    tenantId：租户Id
     *                }
     *              ]
     *          }
     *
     *      }
     *
     *
     *
     * @return
     */
    @PostMapping(value = "execute")
    public CommonResponse<String> execute(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        List<SqlParam> sqlParamList = new ArrayList<>();
        JSONObject warnInfo = null;
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
//        for(JSONObject param : billParams) {
//            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
//            for(SqlParam p : warnParamList) {
//                p.setWarnLevel(param.getString("warnLevel"));
//                p.setTenantId(Long.valueOf(param.getString("tenantId")));
//                p.setValue(p.getValue() / 100d);
//                sqlParamList.add(p);
//            }
//            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
//        }
//
//        warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
//        for(SqlParam p : warnParamList) {
//            p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
//            p.setTenantId(InvocationInfoProxy.getTenantid());
//            p.setValue(p.getValue() / 100d);
//            sqlParamList.add(p);
//        }
        ArrayList<String> projectNameList = new ArrayList<>();
        List<Long> monthlyStatisticsByDate = statisticsService.getMonthlyStatisticsByDate(2022, 5);

        CommonResponse<List<ProjectPoolSetVO>> listCommonResponse = projectPoolApi.queryProjectList("1", null, null);
        if (listCommonResponse.getCode() == 0){
            List<ProjectPoolSetVO> poolSetVOS = listCommonResponse.getData();
            for (ProjectPoolSetVO poolSetVO : poolSetVOS){
                if (!monthlyStatisticsByDate.contains(poolSetVO.getId())){
                    projectNameList.add(poolSetVO.getName());
                }
            }
        }

        if(CollectionUtils.isEmpty(projectNameList)) {
            logger.error("执行合同预警完成，未发现有匹配预警规则的合同信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        return sendWarnToTask(transToWarnVO(projectNameList, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 调用预警中心API发送预警消息
     *
     * @param warnList 预警消息列表
     * @param warnId 预警设置Id
     * @return
     */
    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    /**
     * 将查询出来的业务数据列表按照预警模板转换为预警消息列表
     *
     * @param result 业务数据列表
     * @param defaultWarnInfo 默认预警设置信息
     * @return
     */
    private List<EarlyWarnTransVO> transToWarnVO(List<String> result, JSONObject defaultWarnInfo) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for(String m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            //预警显示 单据名称
            vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + m);
            //单据详情页页签 名称
            vo.setPcTitle("产值统计");
            //组织Id
            vo.setOrgId(1406795679670312962L);
            //组织名称
            vo.setOrgName("郑州一建集团有限公司");
            //单据Id
            //vo.setSourceId(m.get("contractId").toString());
            //单据所属租户Id
            vo.setTenantId(999999L);
            //预警等级
            //vo.setWarnLevel(m.get("warnLevel").toString());
            //预警设置Id
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            //预警设置名称
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            //预警内容模板
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            //预警内容
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#projectName#", m)
            );

            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }

}