/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputvalcount.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputvalcount.vo.BidReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/es/"})
public class EsController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private IOrgApi orgApi;
    private static final String INDEX_NAME = "srglsghttj";
    @Autowired(required=false)
    private RestHighLevelClient client;

    @RequestMapping(value={"esPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BidReportVO>> esPage(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        Page page = new Page();
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (params != null && params.size() > 0) {
            String searchText = this.getParamValue(params, "searchText");
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                MatchQueryBuilder qb1 = QueryBuilders.matchQuery((String)"contractname", (Object)searchText);
                MatchQueryBuilder qb2 = QueryBuilders.matchQuery((String)"suppliername", (Object)searchText);
                boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)qb1).should((QueryBuilder)qb2));
                params.remove("searchText");
            }
            String orgId = this.getParamValue(params, "orgId");
            List<Object> orgIdS = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)orgId)) {
                orgIdS = Arrays.asList(orgId.split(","));
                params.remove("orgId");
            } else {
                List orgVOS = (List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
                if (orgVOS != null && orgVOS.size() > 0) {
                    for (OrgVO vo : orgVOS) {
                        orgIdS.add(String.valueOf(vo.getId()));
                    }
                }
            }
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", orgIdS));
            String startDate = this.getParamValue(params, "startDate");
            String endDate = this.getParamValue(params, "endDate");
            if (startDate != null || endDate != null) {
                RangeQueryBuilder settlementDate = QueryBuilders.rangeQuery((String)"billDate");
                if (startDate != null) {
                    params.remove("startDate");
                    settlementDate.gte((Object)startDate);
                }
                if (endDate != null) {
                    params.remove("endDate");
                    settlementDate.lte((Object)endDate);
                }
                boolQuery.must((QueryBuilder)settlementDate);
            }
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isBlank((CharSequence)value)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        }
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        searchRequest.source(sourceBuilder);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u53c2\u6570   sourceBuilder------------------\uff1a" + JSON.toJSONString((Object)sourceBuilder));
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                this.logger.info("----------------ES\u83b7\u53d6\u6570\u636e\u4e3a--------------\uff1a{}", (Object)sourceAsString);
                list.add(JSON.parseObject((String)sourceAsString, BidReportVO.class));
            }
            page.setCurrent((long)pageNumber);
            page.setSize((long)pageSize);
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e.getMessage());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}

