/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputvalcount.controller.warn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.outputvalcount.controller.warn.SqlParam;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/imageWarn/"})
public class ImageWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IMonthlyStatisticsService statisticsService;

    @PostMapping(value={"execute"})
    public CommonResponse<String> execute(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Calendar now = Calendar.getInstance();
        Integer year = now.get(1);
        Integer month = now.get(2) + 1;
        List warnParamList = null;
        for (JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                if (p.getName().equals("year")) {
                    year = (int)Math.round(p.getValue());
                }
                if (!p.getName().equals("month")) continue;
                month = (int)Math.round(p.getValue());
            }
        }
        String kssj = year + "-" + month + "-1";
        String jssj = year + "-" + month + "-26";
        ArrayList<ProjectSurveyVO> projectList = new ArrayList<ProjectSurveyVO>();
        List<Long> monthlyPlanByDate = this.statisticsService.getImageByDate(kssj, jssj);
        this.logger.info("\u672c\u6708\u4e0a\u62a5\u6570\u91cf\u6570\u91cf\uff1a{}", (Object)monthlyPlanByDate.size());
        CommonResponse listCommonResponse = this.projectPoolApi.queryProjectList("1", null, null, null);
        if (listCommonResponse.getCode() == 0) {
            List poolSetVOS = (List)listCommonResponse.getData();
            this.logger.info("\u9879\u76ee\u6c60\u5728\u5efa\u6570\u91cf\uff1a{}", (Object)poolSetVOS.size());
            for (ProjectSurveyVO poolSetVO : poolSetVOS) {
                if (monthlyPlanByDate.contains(poolSetVO.getId())) continue;
                projectList.add(poolSetVO);
            }
        }
        if (CollectionUtils.isEmpty(projectList)) {
            this.logger.error("\u6267\u884c\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u89c4\u5219\u7684\u9879\u76ee\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.transToWarnVO(projectList, defaultWarnInfo, year, month), defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<ProjectSurveyVO> result, JSONObject defaultWarnInfo, Integer year, Integer month) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (ProjectSurveyVO m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.getProjectName());
            vo.setPcTitle("\u9879\u76ee\u5f71\u50cf\u7ba1\u7406");
            vo.setOrgId(m.getProjectDepartmentId());
            vo.setOrgName(m.getProjectName());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", m.getProjectName()).replaceAll("#year#", year.toString()).replaceAll("#month#", month.toString()));
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }
}

