package com.ejianc.business.outputvalcount.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputvalcount.vo.BidReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.io.Serializable;
import java.util.*;

/**
 * @Author sunxy
 * @Date 22/7/14 11:37
 */
@RestController
@RequestMapping("/es/")
public class EsController implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final long serialVersionUID = 1L;

    private final static Integer QUERY_TIMEOUT = 60;

    @Autowired
    private IOrgApi orgApi;

    /**
     * es索引名
     */
    private final static String INDEX_NAME = "srglsghttj";

    @Autowired(required = false)
    private RestHighLevelClient client;


    /**
     * es查询
     *
     * @return
     */
    @RequestMapping(value = "esPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BidReportVO>> esPage(@RequestBody QueryParam param) {

        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map<String, Parameter> params = param.getParams();

        IPage<BidReportVO> page = new Page<>();
        SearchRequest searchRequest = new SearchRequest(INDEX_NAME);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        //等于
        //boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));

        if (StringUtils.isNotBlank(param.getSearchText())){
            QueryBuilder qb1 = QueryBuilders.matchQuery("contractname", param.getSearchText());
            QueryBuilder qb2 = QueryBuilders.matchQuery("suppliername", param.getSearchText());
            QueryBuilder qb3 = QueryBuilders.matchQuery("pname", param.getSearchText());
            QueryBuilder qb4 = QueryBuilders.matchQuery("billcode", param.getSearchText());
            QueryBuilder qb5 = QueryBuilders.matchQuery("contractId", param.getSearchText());
            QueryBuilder qb6 = QueryBuilders.matchQuery("projectid", param.getSearchText());
            QueryBuilder qb7 = QueryBuilders.matchQuery("orgid", param.getSearchText());
            boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2).should(qb3).should(qb4).should(qb5).should(qb6).should(qb7));
        }
        if (params != null && params.size() > 0) {
                //多字段模糊搜索
//            String searchText = getParamValue(params, "searchText");
//            if (StringUtils.isNotBlank(searchText)) {
//                QueryBuilder qb1 = QueryBuilders.matchQuery("contractname", searchText);
//                QueryBuilder qb2 = QueryBuilders.matchQuery("suppliername", searchText);
//                boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2));
//                params.remove("searchText");
//            }

            String orgId = getParamValue(params, "orgId");
            List<String> orgIdS = new ArrayList<>();
            if (StringUtils.isNotBlank(orgId)) {
            //按指定组织查询
                orgIdS = Arrays.asList(orgId.split(","));
                params.remove("orgId");

            } else {
                List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
                if (orgVOS != null && orgVOS.size() > 0) {
                    for (OrgVO vo : orgVOS) {
                        orgIdS.add(String.valueOf(vo.getId()));
                    }
                }
            }
            //in搜索
            boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));

            String contractId = getParamValue(params, "contractId");
            if (StringUtils.isNotBlank(contractId)) {
                //按指定合同id查询
                params.remove("contractId");

            }
            String projectid = getParamValue(params, "projectid");
            if (StringUtils.isNotBlank(projectid)) {
                //按指定项目id查询
                params.remove("projectid");

            }
            //其他多选检索
//            String xxx = getParamValue(params, "xxx");
//            if (StringUtils.isNotBlank(xxx)){
//                params.remove("xxx");
//                boolQuery.must(QueryBuilders.termsQuery("xxx",  Arrays.asList(xxx.split(","))));
//            }



            //日期范围搜索
//            String startDate = getParamValue(params, "startDate");
//            String endDate = getParamValue(params, "endDate");
//            if (startDate != null || endDate != null) {
//                RangeQueryBuilder settlementDate = QueryBuilders.rangeQuery("billDate");
//                if (startDate != null) {
//                    params.remove("startDate");
//                    settlementDate.gte(startDate);
//                }
//                if (endDate != null) {
//                    params.remove("endDate");
//                    settlementDate.lte(endDate);
//                }
//                boolQuery.must(settlementDate);
//            }
            //
            //其他单字段模糊搜索
            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isBlank(value)) {
                    continue;
                }
                boolQuery.must(QueryBuilders.matchQuery(key, value));
            }
        }


        //根据分页条件设置查询范围
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);

        //排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    sourceBuilder.sort(entry.getKey(), SortOrder.ASC);
                } else {
                    sourceBuilder.sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }

//        sourceBuilder.trackTotalHits(true);
//        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);
        logger.info("打印查询参数   sourceBuilder------------------："+ JSON.toJSONString(sourceBuilder));

        try {
            List<BidReportVO> list = new ArrayList<>();
            //查询及转换
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                logger.info("----------------ES获取数据为--------------：{}",sourceAsString);
                list.add(JSON.parseObject(sourceAsString, BidReportVO.class));
            }
            //TODO 如需要可对数据进行二次加工处理

            page.setCurrent(pageNumber);
            page.setSize(pageSize);
            //查询结果
            page.setRecords(list);
            //总条数
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e.getMessage());
        }
        return CommonResponse.success("查询成功！", page);
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}
