package com.ejianc.business.outputvalcount.api;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.bean.XmyxglEntity;
import com.ejianc.business.outputvalcount.mapper.MonthlyStatisticsMapper;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.business.outputvalcount.service.IXmyxglService;
import com.ejianc.business.outputvalcount.vo.OutputValueVO;
import com.ejianc.business.outputvalcount.vo.XmyxglVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/outputValue/")
public class OutputValueApi {

    @Autowired
    private MonthlyStatisticsMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IXmyxglService service;
    @Autowired
    private IAttachmentApi attachmentApi;

    /**
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "getSumByProjectId", method= RequestMethod.GET)
    CommonResponse<OutputValueVO> getSumByProjectId(@RequestParam(value = "projectId") Long projectId){
        //获取当前项目的所有单据
        String name = "";
        List<MonthlyStatisticsEntity> monthlyStatistics = mapper.getMonthlyStatistics(projectId);
        BigDecimal sum = new BigDecimal(0);//开工累计金额

        for(MonthlyStatisticsEntity entity : monthlyStatistics){
            name = entity.getProjectName();
            if(entity.getBillState() == 1 || entity.getBillState() == 3){
                sum = sum.add(entity.getBywccz());
            }

        }
        OutputValueVO outputValueVO = new OutputValueVO();

        //CommonResponse<OrgVO> oneById = iOrgApi.getOneById(projectId);
//        if(oneById.getCode()==0){
//            OrgVO data = oneById.getData();
//            outputValueVO.setProjectName(data.getName());
//        }
        outputValueVO.setProjectName(name);
        outputValueVO.setProjectId(projectId);
        outputValueVO.setSum(sum);
        return CommonResponse.success("获取数据成功！",outputValueVO);
    }


    /**
     *
     * @param projectId
     * @param num
     * @return
     */
    @RequestMapping(value = "getInfoByProjectId", method= RequestMethod.GET)
    CommonResponse<List<XmyxglVO>> getInfoByProjectId(@RequestParam(value = "projectId") Long projectId,@RequestParam(value = "num") Integer num) {
        //获取当前组织下的所有项目、组织
        List<OrgVO> respData = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(projectId), true, "查询失败，获取当前本下组织信息失败。");
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        respData.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            }
        });

        //获取当前项目的所有单据
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime",QueryParam.DESC);
        queryParam.setPageSize(num);//获取的个数由传入的参数决定
       queryParam.setPageIndex(1);
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        List<Integer> billStates = new ArrayList<>();
        billStates.add(1);
        billStates.add(3);
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStates));
        queryParam.getParams().put("syxs", new Parameter(QueryParam.EQ, 2));
        IPage<XmyxglEntity> xmyxglEntityIPage = service.queryPage(queryParam, false);
        List<XmyxglVO> xmyxglVOS = BeanMapper.mapList(xmyxglEntityIPage.getRecords(), XmyxglVO.class);
        //获取表单附件的地址
        for (XmyxglVO vo:xmyxglVOS) {
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(vo.getId(), "ZZYJ202205050002", "add", "");
            if (listCommonResponse.getCode() == 0){
                List<AttachmentVO> data = listCommonResponse.getData();
                if (data.size()>0){
                    vo.setTruePath(data.get(0).getTruePath());//附件上传多个则取第一张图片
                }
            }
        }

        return CommonResponse.success("获取数据成功！",xmyxglVOS);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 获取本项目的层级的  所有产值
     * @param orgId
     * @return
     */
    @RequestMapping(value = "getSumByOrgId", method= RequestMethod.GET)
    CommonResponse<OutputValueVO> getSumByOrgId(@RequestParam(value = "orgId") Long orgId){
        //获取当前项目的所有单据
        List<MonthlyStatisticsEntity> monthlyStatistics = mapper.getMonthlyStatisticsByDeptId(orgId);
        BigDecimal sum = new BigDecimal(0);//开工累计金额

        for(MonthlyStatisticsEntity entity : monthlyStatistics){
            if(entity.getBillState() == 1 || entity.getBillState() == 3){
                sum = sum.add(entity.getBywccz());
            }
        }
        OutputValueVO outputValueVO = new OutputValueVO();

        CommonResponse<OrgVO> oneById = iOrgApi.getOneById(orgId);
        if(oneById.getCode()==0){
            OrgVO data = oneById.getData();
            outputValueVO.setProjectName(data.getName());
        }
        outputValueVO.setProjectId(orgId);
        outputValueVO.setSum(sum);
        return CommonResponse.success("获取数据成功！",outputValueVO);
    }

    /**
     * 获取本下单位的总产值  按年度取产值
     * @param orgId
     * @return
     */
    @RequestMapping(value = "getSumByOrgIdUnder", method= RequestMethod.GET)
    CommonResponse<BigDecimal> getSumByOrgIdUnder(@RequestParam(value = "orgId") Long orgId,
                                                  @RequestParam(value = "year") Integer year){
        //获取当前项目的所有单据
        //获取当前组织下的所有项目、组织
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        /** ywDate */
        param.getParams().put("ywDate", new Parameter(QueryParam.BETWEEN,
                year+"-1-1,"+year+"-12-31"));

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<MonthlyStatisticsEntity> monthlyStatistics = mapper.getSumByOrgIdUnder(wrapper);

        BigDecimal sum = new BigDecimal(0);//开工累计金额

        for(MonthlyStatisticsEntity entity : monthlyStatistics){
            if(entity.getBillState() == 1 || entity.getBillState() == 3){
                sum = sum.add(entity.getBywccz());
            }
        }

        return CommonResponse.success("获取数据成功！",sum);
    }
}
