package com.ejianc.business.outputvalcount.controller;

import java.io.Serializable;

import com.ejianc.business.outputvalcount.utils.SMS;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.outputvalcount.bean.CheckEntity;
import com.ejianc.business.outputvalcount.service.ICheckService;
import com.ejianc.business.outputvalcount.vo.CheckVO;

/**
 * 校验信息
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("check")
public class CheckController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ICheckService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@RequestBody CheckVO saveOrUpdateVO) {
    	CheckEntity entity = BeanMapper.map(saveOrUpdateVO, CheckEntity.class);
        if (saveOrUpdateVO.getPhone() != null) {//手机号不为空
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("phone", new Parameter(QueryParam.EQ, saveOrUpdateVO.getPhone()));
            queryParam.getParams().put("yxzt", new Parameter(QueryParam.EQ, 1));
            List<CheckEntity> checkEntities = service.queryList(queryParam);
            if (checkEntities.size()>0){
                return CommonResponse.error("请勿重复获取验证码！");
            }
        }else {
            return CommonResponse.error("请输入手机号！");
        }
        int yzm = (int)((Math.random()*9+1)*100000);//6位随机验证码
        entity.setYzm(yzm);
        entity.setYxzt(1);

    	service.saveOrUpdate(entity, false);

        //短信内容
        String context="您的验证码为："+yzm+" 【郑州一建】";
        //发送验证码
        SMS.setSendSms(saveOrUpdateVO.getPhone()+"",context);

    	CheckVO vo = BeanMapper.map(entity, CheckVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description
     * @param
     */
    @RequestMapping(value = "/checkYzm", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryDetail(Long phone,Integer yzm) {

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("phone", new Parameter(QueryParam.EQ, phone));
        queryParam.getParams().put("yxzt", new Parameter(QueryParam.EQ, 1));
        List<CheckEntity> checkEntities = service.queryList(queryParam);
        if (checkEntities.size()>0){
            CheckEntity checkEntity = checkEntities.get(0);
            if (checkEntity.getYzm().equals(yzm)){
                checkEntity.setYxzt(2);
                service.saveOrUpdate(checkEntity);
                return CommonResponse.success("验证码校验成功！");
            }else {
                return CommonResponse.error("验证码输入错误！");
            }
        }else {
            return CommonResponse.error("未获取验证码或验证码已失效！");
        }
    }


}
