package com.ejianc.business.outputvalcount.controller.warn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;

/**
 * @author CJ
 * @Description:
 * @date 2022/6/6 11:22
 */
@RestController
@RequestMapping(value = "/statisticsWarn/")
public class StatisticsWarnController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IMonthlyStatisticsService statisticsService;


    /**
     * 预警服务
     *
     * @param jsonParam
     *      jsonParam {
     *          ignoreTenantIds: 忽略租户列表
     *          billParams：预警参数列表，
     *          defaultParam：{ 预警默认设置
     *              warnLevel：预警等级
     *              tenantId：租户Id
     *              warnSetId：预警设置Id
     *              earlywarnName：预警设置名称
     *              earlywarnContent：预警设置内容模板
     *              parameters：[ 默认预警参数
     *                {
     *                    name: 参数名称，
     *                    property：参数属性
     *                    type：参数类型
     *                    value：参数值
     *                    unit：参数单位
     *                    tenantId：租户Id
     *                }
     *              ]
     *          }
     *
     *      }
     *
     *
     *
     * @return
     */
    @PostMapping(value = "execute")
    public CommonResponse<String> execute(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        //如果前天传了年月，就使用前台传的年月，否则则使用当前日期的年月
        Calendar now = Calendar.getInstance();
        Integer year = now.get(Calendar.YEAR);
        Integer month = now.get(Calendar.MONTH) + 1;

        List<SqlParam> warnParamList = null;
        for(JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                if (p.getName().equals("year")){
                    year = (int)Math.round( p.getValue());
                }
                if (p.getName().equals("month")){
                    month = (int)Math.round( p.getValue());
                }
            }
        }

        ArrayList<ProjectSurveyVO> projectList = new ArrayList<>();


       // List<Long> monthlyStatisticsByDate = statisticsService.getMonthlyStatisticsByDate(now.get(Calendar.YEAR), (now.get(Calendar.MONTH) + 1));
        List<Long> monthlyStatisticsByDate = statisticsService.getMonthlyStatisticsByDate(year,month);
        logger.info("本月上报数量数量：{}", monthlyStatisticsByDate.size());
        CommonResponse<List<ProjectSurveyVO>> listCommonResponse = projectPoolApi.queryProjectList("1", null, null,null);
        if (listCommonResponse.getCode() == 0){
            List<ProjectSurveyVO> poolSetVOS = listCommonResponse.getData();
            logger.info("项目池在建数量：{}", poolSetVOS.size());
            for (ProjectSurveyVO poolSetVO : poolSetVOS){
                if (!monthlyStatisticsByDate.contains(poolSetVO.getId())){
                    projectList.add(poolSetVO);
                }
            }
        }

        if(CollectionUtils.isEmpty(projectList)) {
            logger.error("执行完成，未发现有匹配规则的项目信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        return sendWarnToTask(transToWarnVO(projectList, defaultWarnInfo,year,month), defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 调用预警中心API发送预警消息
     *
     * @param warnList 预警消息列表
     * @param warnId 预警设置Id
     * @return
     */
    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    /**
     * 将查询出来的业务数据列表按照预警模板转换为预警消息列表
     *
     * @param result 业务数据列表
     * @param defaultWarnInfo 默认预警设置信息
     * @return
     */
    private List<EarlyWarnTransVO> transToWarnVO(List<ProjectSurveyVO> result, JSONObject defaultWarnInfo,Integer year ,Integer month) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        for(ProjectSurveyVO m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            //预警显示 单据名称
            vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + m.getProjectName());
            //单据详情页页签 名称
            vo.setPcTitle("产值统计");
            //组织Id
            vo.setOrgId(m.getProjectDepartmentId());
            //组织名称
            vo.setOrgName(m.getProjectName());
            //单据Id
            //vo.setSourceId(m.get("contractId").toString());
            //单据所属租户Id
            vo.setTenantId(999999L);
            //预警等级
            vo.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
            //预警设置Id
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            //预警设置名称
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            //预警内容模板
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            //预警内容
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#projectName#", m.getProjectName())
                                .replaceAll("#year#", year.toString())
                                .replaceAll("#month#", month.toString())
            );

            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }

}