package com.ejianc.business.outputvalcount.controller.warn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;

/**
 * @author CJ
 * @Description:
 * @date 2022/6/6 11:22
 */
@RestController
@RequestMapping(value = "/statisticsWarn/")
public class StatisticsWarnController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IMonthlyStatisticsService statisticsService;


    /**
     * 预警服务
     *
     *
     *
     *
     * @return
     */
    @PostMapping(value = "execute")
    public CommonResponse<String> execute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        String warnCode = null;
        if (jsonParam.size() > 0) {
            JSONObject o = jsonParam.getJSONObject(0);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray settings = o.getJSONArray("settings");
            JSONObject orgSet = null;
            JSONObject defaultSet = null;

            /** 查找默认的 */
            for (int i1 = 0; i1 < settings.size(); i1++) {
                JSONObject set = settings.getJSONObject(i1);
                if (set.getBoolean("default")) {
                    defaultSet = set;
                    break;
                }
            }
            if (orgSet == null) {
                /** 使用默认配置 */
                orgSet = defaultSet;
            }
            if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                JSONArray warningSetings = orgSet.getJSONArray("warningSetings");
                JSONObject billParams = warningSetings.getJSONObject(0);
                String parameterValue = billParams.getString("parameterValue");

                //如果前天传了年月，就使用前台传的年月，否则则使用当前日期的年月
                Calendar now = Calendar.getInstance();
                Integer year = now.get(Calendar.YEAR);
                Integer month = now.get(Calendar.MONTH) + 1;

                if (StringUtils.isNotEmpty(parameterValue)) {
                    month = Integer.valueOf(parameterValue);
                }

                ArrayList<ProjectSurveyVO> projectList = new ArrayList<>();


                // List<Long> monthlyStatisticsByDate = statisticsService.getMonthlyStatisticsByDate(now.get(Calendar.YEAR), (now.get(Calendar.MONTH) + 1));
                List<Long> monthlyStatisticsByDate = statisticsService.getMonthlyStatisticsByDate(year, month);
                logger.info("本月上报数量数量：{}", monthlyStatisticsByDate.size());
                CommonResponse<List<ProjectSurveyVO>> listCommonResponse = projectPoolApi.queryProjectList("1", null, null, "henan");
                logger.info("查找项目池返回的消息：{}", listCommonResponse.getMsg());
                if (listCommonResponse.getCode() == 0) {
                    List<ProjectSurveyVO> poolSetVOS = listCommonResponse.getData();
                    logger.info("项目池在建数量：{}", poolSetVOS.size());
                    for (ProjectSurveyVO poolSetVO : poolSetVOS) {
                        if (!monthlyStatisticsByDate.contains(poolSetVO.getId())) {
                            projectList.add(poolSetVO);
                        }
                    }
                }

                if (CollectionUtils.isEmpty(projectList)) {
                    logger.error("执行完成，未发现有匹配规则的项目信息！");
                    return sendWarnToTask(new ArrayList<>(), warnCode);
                }

                return sendWarnToTask(transToWarnVO(projectList, orgSet,billParams,year, month), warnCode);
            }else {
                return CommonResponse.error("获取参数失败！");
            }
        }
        return CommonResponse.error("获取参数失败！");
    }

    /**
     * 调用预警中心API发送预警消息
     *
     * @param warnList 预警消息列表
     * @param warnCode 预警设置Id
     * @return
     */
    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    /**
     * 将查询出来的业务数据列表按照预警模板转换为预警消息列表
     *
     * @param result 业务数据列表
     * @param orgSet 默认预警设置信息
     * @return
     */
    private List<EarlyWarnTransVO> transToWarnVO(List<ProjectSurveyVO> result, JSONObject orgSet,JSONObject billParams,Integer year ,Integer month) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        for(ProjectSurveyVO m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            //预警显示 单据名称
            vo.setBillName((null != orgSet.get("moduleName") ? orgSet.get("moduleName").toString() + " - " : "")  + m.getProjectName());
            //单据详情页页签 名称
            vo.setPcTitle("月度产值统计");
            //
            //vo.setPcUrl(PC_URL +m.getId());
            //组织Id
            vo.setOrgId(m.getOrgId());

            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
            vo.setSendOrgId(m.getOrgId()+"");
            //组织名称
            //vo.setOrgName(m.getOrg);
            //单据Id
            //vo.setSourceId(m.getBillCode());
            //单据所属租户Id
            vo.setTenantId(999999L);
            //预警等级
            vo.setWarnLevel(billParams.getString("warningLevel"));

            vo.setWarnSetParamId(billParams.getLong("id"));
            //预警设置Id
            vo.setWarnSetId(orgSet.getLong("warnId"));
            //预警设置名称
            vo.setEarlywarnName(orgSet.getString("warnName"));

            vo.setWarnType(orgSet.getString("warnType"));

            //预警内容模板
            tmpContent = orgSet.getString("warningContentTemplate");
            //预警内容
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#projectName#", m.getProjectName())
                                .replaceAll("#year#", year.toString())
                                .replaceAll("#month#", month.toString())
            );

            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }

}