/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputvalcount.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputvalcount.bean.MonthlyPlanEntity;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.bean.XmjdmxEntity;
import com.ejianc.business.outputvalcount.bean.XmyxglEntity;
import com.ejianc.business.outputvalcount.mapper.XmjdmxMapper;
import com.ejianc.business.outputvalcount.service.IMonthlyPlanService;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.business.outputvalcount.service.IXmjdmxService;
import com.ejianc.business.outputvalcount.service.IXmyxglService;
import com.ejianc.business.outputvalcount.vo.MonthlyPlanVO;
import com.ejianc.business.outputvalcount.vo.MonthlyStatisticsVO;
import com.ejianc.business.outputvalcount.vo.ProductionVO;
import com.ejianc.business.outputvalcount.vo.XmjdmxVO;
import com.ejianc.business.outputvalcount.vo.XmyxglVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"xmjdmx"})
public class XmjdmxController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IXmjdmxService service;
    @Autowired
    private IMonthlyStatisticsService statisticsService;
    @Autowired
    private IMonthlyPlanService planService;
    @Autowired
    private IXmyxglService xmyxglService;
    @Autowired
    private XmjdmxMapper mapper;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<XmjdmxVO> queryDetail(Long id) {
        XmjdmxEntity entity = (XmjdmxEntity)((Object)this.service.selectById(id));
        XmjdmxVO vo = new XmjdmxVO();
        if (entity == null) {
            return CommonResponse.success((String)"\u8be5\u9879\u76ee\u5c1a\u672a\u4e0a\u62a5\u9879\u76ee\u8fdb\u5ea6\u6570\u636e\uff01", (Object)vo);
        }
        vo = (XmjdmxVO)BeanMapper.map((Object)((Object)entity), XmjdmxVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        LinkedHashMap orderMap = param.getOrderMap();
        orderMap.put("createTime", "desc");
        ArrayList<MonthlyStatisticsVO> statisticsVOList = new ArrayList<MonthlyStatisticsVO>();
        List monthlyStatisticsEntities = this.statisticsService.queryList(param);
        for (MonthlyStatisticsEntity statisticsEntity : monthlyStatisticsEntities) {
            MonthlyStatisticsVO map = (MonthlyStatisticsVO)BeanMapper.map((Object)((Object)statisticsEntity), MonthlyStatisticsVO.class);
            statisticsVOList.add(map);
        }
        vo.setStatisticsList(statisticsVOList);
        ArrayList<MonthlyPlanVO> planVOList = new ArrayList<MonthlyPlanVO>();
        List monthlyPlanEntities = this.planService.queryList(param);
        for (MonthlyPlanEntity planEntity : monthlyPlanEntities) {
            MonthlyPlanVO map = (MonthlyPlanVO)BeanMapper.map((Object)((Object)planEntity), MonthlyPlanVO.class);
            planVOList.add(map);
        }
        vo.setPlanList(planVOList);
        QueryParam param1 = new QueryParam();
        param1.getParams().put("xmId", new Parameter("eq", (Object)entity.getProjectId()));
        param1.getParams().put("dr", new Parameter("eq", (Object)0));
        param1.getOrderMap().put("createTime", "desc");
        ArrayList<XmyxglVO> xmyxglList = new ArrayList<XmyxglVO>();
        List xmyxglEntities = this.xmyxglService.queryList(param1);
        for (XmyxglEntity xmyxglEntity : xmyxglEntities) {
            XmyxglVO map = (XmyxglVO)BeanMapper.map((Object)((Object)xmyxglEntity), XmyxglVO.class);
            xmyxglList.add(map);
        }
        vo.setXmyxglList(xmyxglList);
        List<ProductionVO> production = this.mapper.getProduction(entity.getProjectId());
        vo.setProductionList(production);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<XmjdmxVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (XmjdmxVO xmjdmxVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        BigDecimal sumValue = this.mapper.getSumValue(wrapper).divide(new BigDecimal(10000), 2, 4);
        BigDecimal sumValue1 = this.mapper.getSumValue1(wrapper).divide(new BigDecimal(10000), 2, 4);
        IPage page = this.service.queryPage(param, false);
        JSONObject pageJson = new JSONObject();
        pageJson.put("records", (Object)BeanMapper.mapList((Iterable)page.getRecords(), XmjdmxVO.class));
        pageJson.put("total", (Object)page.getTotal());
        pageJson.put("current", (Object)page.getCurrent());
        pageJson.put("size", (Object)page.getSize());
        pageJson.put("pages", (Object)page.getPages());
        pageJson.put("sumValue", (Object)sumValue);
        pageJson.put("sumValue1", (Object)sumValue1);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageJson);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Xmjdmx-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refXmjdmxData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<XmjdmxVO>> refXmjdmxData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), XmjdmxVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

