package com.ejianc.business.outputvalcount.service;

import com.ejianc.business.outputvalcount.vo.PaymentApplyVO;
import com.ejianc.business.outputvalcount.vo.SettlePoolVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 校验信息
 * 
 * @author generator
 * 
 */
public interface IEsService  {
    /**
     * 根据合同id查询当前合同下结算列表
     * @param contractId 合同id
     * @return 查询结果  queryDetailRecordNoContract
     */
    List<SettlePoolVO> queryDetailRecord(Long contractId);
    List<SettlePoolVO> queryDetailRecordNoContract(Long projectId,Long supplierId);

    List<PaymentApplyVO> queryDetailRecord1(Long contractId);
    List<PaymentApplyVO> queryDetailRecordNoContract1(Long projectId,Long supplierId);

    /**
     * 跨库查询合同总总额
     * @param tenantId
     * @param orgId
     * @return 合同总金额
     */
    BigDecimal totalContract(Long tenantId, Long orgId);
    /**
     * 跨库查询合同实付总额
     * @param tenantId
     * @param orgId
     * @return 合同实付金额
     */
    BigDecimal queryAmountMny(Long tenantId, Long orgId);
}
