package com.ejianc.business.outputvalcount.mapper;

import com.ejianc.business.outputvalcount.bean.CheckEntity;
import com.ejianc.business.outputvalcount.vo.PaymentApplyVO;
import com.ejianc.business.outputvalcount.vo.SettlePoolVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;

import java.math.BigDecimal;
import java.util.List;

/**
 * 校验信息
 * 
 * @author generator
 * 
 */
@Mapper
public interface EsMapper {
    List<SettlePoolVO> queryDetailRecord(Long contractId);

    List<SettlePoolVO> queryDetailRecordNoContract(Long projectId,Long supplierId);

    List<PaymentApplyVO> queryDetailRecord1(Long contractId);

    List<PaymentApplyVO> queryDetailRecordNoContract1(Long projectId,Long supplierId);

    //跨库查询合同总总额，传递参数为projectId和orgId
    BigDecimal totalContract(Long tenantId,Long orgId);


    //跨库查询合同实付金额
    BigDecimal actualMny(Long tenantId,Long orgId);
    //跨库查询合同实付金额
    BigDecimal applyMny(Long tenantId,Long orgId);

}
