/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputvalcount.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputvalcount.service.IEsService;
import com.ejianc.business.outputvalcount.utils.Base64Method;
import com.ejianc.business.outputvalcount.vo.BidReportVO;
import com.ejianc.business.outputvalcount.vo.EmployeeReportVO;
import com.ejianc.business.outputvalcount.vo.MaterialReportVO;
import com.ejianc.business.outputvalcount.vo.PaymentApplyVO;
import com.ejianc.business.outputvalcount.vo.ProfinanceReportVO;
import com.ejianc.business.outputvalcount.vo.SalaryReportVO;
import com.ejianc.business.outputvalcount.vo.SettleDetailVO;
import com.ejianc.business.outputvalcount.vo.SettlePoolVO;
import com.ejianc.business.outputvalcount.vo.ZcReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/es/"})
public class EsController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String INDEX_NAME = "srglsghttj";
    @Autowired(required=false)
    private RestHighLevelClient client;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IEsService esService;

    @RequestMapping(value={"esPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BidReportVO>> esPage(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        Page page = new Page();
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            MatchQueryBuilder qb1 = QueryBuilders.matchQuery((String)"contractName", (Object)param.getSearchText());
            MatchQueryBuilder qb2 = QueryBuilders.matchQuery((String)"supplierName", (Object)param.getSearchText());
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)"pName", (Object)param.getSearchText());
            MatchQueryBuilder qb4 = QueryBuilders.matchQuery((String)"billCode", (Object)param.getSearchText());
            boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)qb1).should((QueryBuilder)qb2).should((QueryBuilder)matchQueryBuilder).should((QueryBuilder)qb4));
        }
        if (params != null && params.size() > 0) {
            String string;
            String projectid;
            String contractId = this.getParamValue(params, "aId");
            if (StringUtils.isNotBlank((CharSequence)contractId)) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"aId", (String)contractId));
                params.remove("aId");
            }
            if (StringUtils.isNotBlank((CharSequence)(projectid = this.getParamValue(params, "pId")))) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"pId", (String)projectid));
                params.remove("pId");
            }
            if (StringUtils.isNotBlank((CharSequence)(string = this.getParamValue(params, "orgId")))) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"orgId", (String)string));
                params.remove("orgId");
            } else {
                ArrayList orgIdS = new ArrayList();
                List list = (List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
                if (list != null && list.size() > 0) {
                    for (OrgVO vo : list) {
                        orgIdS.add(String.valueOf(vo.getId()));
                    }
                }
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)orgIdS));
            }
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isBlank((CharSequence)value)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        } else {
            ArrayList<String> orgIdS = new ArrayList<String>();
            List orgVOS = (List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
            if (orgVOS != null && orgVOS.size() > 0) {
                Iterator iterator = orgVOS.iterator();
                while (iterator.hasNext()) {
                    OrgVO vo = (OrgVO)iterator.next();
                    orgIdS.add(String.valueOf(vo.getId()));
                }
            }
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", orgIdS));
        }
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase((String)entry.getValue())) {
                    sourceBuilder.sort((String)entry.getKey(), SortOrder.ASC);
                    continue;
                }
                sourceBuilder.sort((String)entry.getKey(), SortOrder.DESC);
            }
        }
        searchRequest.source(sourceBuilder);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u53c2\u6570   sourceBuilder------------------\uff1a" + JSON.toJSONString((Object)sourceBuilder));
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, BidReportVO.class));
            }
            page.setCurrent((long)pageNumber);
            page.setSize((long)pageSize);
            page.setRecords(list);
            page.setTotal((long)list.size());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e.getMessage());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"sbPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialReportVO>> sbPage(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        Page page = new Page();
        SearchRequest searchRequest = new SearchRequest(new String[]{"lxfy_lgljlcls"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            MatchQueryBuilder qb1 = QueryBuilders.matchQuery((String)"orgName", (Object)param.getSearchText());
            MatchQueryBuilder qb2 = QueryBuilders.matchQuery((String)"projectCode", (Object)param.getSearchText());
            MatchQueryBuilder qb3 = QueryBuilders.matchQuery((String)"projectName", (Object)param.getSearchText());
            MatchQueryBuilder qb4 = QueryBuilders.matchQuery((String)"ywLxname", (Object)param.getSearchText());
            boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)qb1).should((QueryBuilder)qb2).should((QueryBuilder)qb3).should((QueryBuilder)qb4));
        }
        ArrayList<String> orgIdS = new ArrayList<String>();
        List orgVOS = (List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
        if (orgVOS != null && orgVOS.size() > 0) {
            for (OrgVO vo : orgVOS) {
                orgIdS.add(String.valueOf(vo.getId()));
            }
        }
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", orgIdS));
        if (params != null && params.size() > 0) {
            String string;
            Object projectid;
            String ywLx = this.getParamValue(params, "ywLx");
            if (StringUtils.isNotBlank((CharSequence)ywLx)) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"ywLx", (String)ywLx));
                params.remove("ywLx");
            }
            if (StringUtils.isNotBlank((CharSequence)(projectid = this.getParamValue(params, "projectId")))) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"projectId", (String)projectid));
                params.remove("projectId");
            }
            if ((string = this.getParamValue(params, "ywDate")) != null) {
                RangeQueryBuilder settlementDate = QueryBuilders.rangeQuery((String)"ywDate");
                List<String> list = Arrays.asList(string.split(","));
                params.remove("ywDate");
                if (list.size() >= 2) {
                    settlementDate.gte((Object)list.get(0));
                    settlementDate.lte((Object)list.get(1));
                    boolQuery.must((QueryBuilder)settlementDate);
                }
            }
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isBlank((CharSequence)value)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        }
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase((String)entry.getValue())) {
                    sourceBuilder.sort((String)entry.getKey(), SortOrder.ASC);
                    continue;
                }
                sourceBuilder.sort((String)entry.getKey(), SortOrder.DESC);
            }
        }
        searchRequest.source(sourceBuilder);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u53c2\u6570   sourceBuilder------------------\uff1a" + JSON.toJSONString((Object)sourceBuilder));
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, MaterialReportVO.class));
            }
            page.setCurrent((long)pageNumber);
            page.setSize((long)pageSize);
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e.getMessage());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(value={"zcPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ZcReportVO>> zcPage(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        Page page = new Page();
        SearchRequest searchRequest = new SearchRequest(new String[]{"ex_contract"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            MatchQueryBuilder qb1 = QueryBuilders.matchQuery((String)"contractName", (Object)param.getSearchText());
            MatchQueryBuilder qb2 = QueryBuilders.matchQuery((String)"supplierName", (Object)param.getSearchText());
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)"projectName", (Object)param.getSearchText());
            MatchQueryBuilder qb4 = QueryBuilders.matchQuery((String)"billCode", (Object)param.getSearchText());
            MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchQuery((String)"partyName", (Object)param.getSearchText());
            MatchQueryBuilder qb6 = QueryBuilders.matchQuery((String)"categorypName", (Object)param.getSearchText());
            MatchQueryBuilder qb7 = QueryBuilders.matchQuery((String)"categoryName", (Object)param.getSearchText());
            boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)qb1).should((QueryBuilder)qb2).should((QueryBuilder)matchQueryBuilder).should((QueryBuilder)qb4).should((QueryBuilder)matchQueryBuilder2).should((QueryBuilder)qb6).should((QueryBuilder)qb7));
        }
        if (params != null && params.size() > 0) {
            String string;
            String projectid;
            String contractId = this.getParamValue(params, "billId");
            if (StringUtils.isNotBlank((CharSequence)contractId)) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"billId", (String)contractId));
                params.remove("billId");
            }
            if (StringUtils.isNotBlank((CharSequence)(projectid = this.getParamValue(params, "projectId")))) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"projectId", (String)projectid));
                params.remove("projectId");
            }
            if (StringUtils.isNotBlank((CharSequence)(string = this.getParamValue(params, "orgId")))) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"orgId", (String)string));
                params.remove("orgId");
            } else {
                ArrayList orgIdS = new ArrayList();
                List list = (List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
                if (list != null && list.size() > 0) {
                    for (OrgVO vo : list) {
                        orgIdS.add(String.valueOf(vo.getId()));
                    }
                }
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)orgIdS));
            }
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isBlank((CharSequence)value)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        } else {
            ArrayList<String> orgIdS = new ArrayList<String>();
            List orgVOS = (List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
            if (orgVOS != null && orgVOS.size() > 0) {
                Iterator iterator = orgVOS.iterator();
                while (iterator.hasNext()) {
                    OrgVO vo = (OrgVO)iterator.next();
                    orgIdS.add(String.valueOf(vo.getId()));
                }
            }
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", orgIdS));
        }
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase((String)entry.getValue())) {
                    sourceBuilder.sort((String)entry.getKey(), SortOrder.ASC);
                    continue;
                }
                sourceBuilder.sort((String)entry.getKey(), SortOrder.DESC);
            }
        }
        searchRequest.source(sourceBuilder);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u53c2\u6570   sourceBuilder------------------\uff1a" + JSON.toJSONString((Object)sourceBuilder));
        try {
            void var13_28;
            ArrayList<Object> list = new ArrayList<Object>();
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            this.logger.info("----------------response\u83b7\u53d6\u6570\u636e\u4e3a--------------\uff1a{}", (Object)JSON.toJSONString((Object)searchResponse));
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, ZcReportVO.class));
            }
            boolean bl = false;
            while (var13_28 < list.size() - 1) {
                for (int j = list.size() - 1; j > var13_28; --j) {
                    if (!((ZcReportVO)list.get(j)).getBillid().equals(((ZcReportVO)list.get((int)var13_28)).getBillid())) continue;
                    list.remove(j);
                }
                ++var13_28;
            }
            page.setCurrent((long)pageNumber);
            page.setSize((long)pageSize);
            page.setRecords(list);
            page.setTotal((long)list.size());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e.getMessage());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"gzffPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalaryReportVO>> gzffPage(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        Page page = new Page();
        SearchRequest searchRequest = new SearchRequest(new String[]{"profinance_salary"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            MatchQueryBuilder qb1 = QueryBuilders.matchQuery((String)"salaryBillCode", (Object)param.getSearchText());
            MatchQueryBuilder qb2 = QueryBuilders.matchQuery((String)"projectName", (Object)param.getSearchText());
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)"groupName", (Object)param.getSearchText());
            MatchQueryBuilder qb4 = QueryBuilders.matchQuery((String)"contractCode", (Object)param.getSearchText());
            MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchQuery((String)"contractName", (Object)param.getSearchText());
            MatchQueryBuilder qb6 = QueryBuilders.matchQuery((String)"workerIdCard", (Object)param.getSearchText());
            MatchQueryBuilder qb7 = QueryBuilders.matchQuery((String)"workerName", (Object)param.getSearchText());
            boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)qb1).should((QueryBuilder)qb2).should((QueryBuilder)matchQueryBuilder).should((QueryBuilder)qb4).should((QueryBuilder)matchQueryBuilder2).should((QueryBuilder)qb6).should((QueryBuilder)qb7));
        }
        if (params != null && params.size() > 0) {
            String string;
            Object contractId;
            String workerIdCard = this.getParamValue(params, "workerIdCard");
            if (StringUtils.isNotBlank((CharSequence)workerIdCard)) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"workerIdCard", (Object)workerIdCard));
                params.remove("workerIdCard");
            }
            if (StringUtils.isNotBlank((CharSequence)(contractId = this.getParamValue(params, "contractId")))) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"contractId", (String)contractId));
                params.remove("contractId");
            }
            if (StringUtils.isNotBlank((CharSequence)(string = this.getParamValue(params, "projectId")))) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"projectId", (String)string));
                params.remove("projectId");
            }
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isBlank((CharSequence)value)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        }
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase((String)entry.getValue())) {
                    sourceBuilder.sort((String)entry.getKey(), SortOrder.ASC);
                    continue;
                }
                sourceBuilder.sort((String)entry.getKey(), SortOrder.DESC);
            }
        }
        searchRequest.source(sourceBuilder);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u53c2\u6570   sourceBuilder------------------\uff1a" + JSON.toJSONString((Object)sourceBuilder));
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, SalaryReportVO.class));
            }
            page.setCurrent((long)pageNumber);
            page.setSize((long)pageSize);
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e.getMessage());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"gzPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProfinanceReportVO>> gzPage(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        Page page = new Page();
        SearchRequest searchRequest = new SearchRequest(new String[]{"labor_sumsalary"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            MatchQueryBuilder qb1 = QueryBuilders.matchQuery((String)"projectCode", (Object)param.getSearchText());
            MatchQueryBuilder qb2 = QueryBuilders.matchQuery((String)"projectName", (Object)param.getSearchText());
            MatchQueryBuilder qb3 = QueryBuilders.matchQuery((String)"orgName", (Object)param.getSearchText());
            MatchQueryBuilder qb4 = QueryBuilders.matchQuery((String)"contractCode", (Object)param.getSearchText());
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)"contractName", (Object)param.getSearchText());
            MatchQueryBuilder qb6 = QueryBuilders.matchQuery((String)"workerIdCard", (Object)param.getSearchText());
            MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchQuery((String)"workerName", (Object)param.getSearchText());
            boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)qb1).should((QueryBuilder)qb2).should((QueryBuilder)qb3).should((QueryBuilder)qb4).should((QueryBuilder)matchQueryBuilder).should((QueryBuilder)qb6).should((QueryBuilder)matchQueryBuilder2));
        }
        ArrayList<String> orgIdS = new ArrayList<String>();
        List orgVOS = (List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
        if (orgVOS != null && orgVOS.size() > 0) {
            for (OrgVO vo : orgVOS) {
                orgIdS.add(String.valueOf(vo.getId()));
            }
        }
        boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", orgIdS));
        if (params != null && params.size() > 0) {
            String string;
            Object contractId;
            String workerIdCard = this.getParamValue(params, "workerIdCard");
            if (StringUtils.isNotBlank((CharSequence)workerIdCard)) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"workerIdCard", (String)workerIdCard));
                params.remove("workerIdCard");
            }
            if (StringUtils.isNotBlank((CharSequence)(contractId = this.getParamValue(params, "contractId")))) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"contractId", (String)contractId));
                params.remove("contractId");
            }
            if (StringUtils.isNotBlank((CharSequence)(string = this.getParamValue(params, "projectId")))) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"projectId", (String)string));
                params.remove("projectId");
            }
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isBlank((CharSequence)value)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        }
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase((String)entry.getValue())) {
                    sourceBuilder.sort((String)entry.getKey(), SortOrder.ASC);
                    continue;
                }
                sourceBuilder.sort((String)entry.getKey(), SortOrder.DESC);
            }
        }
        searchRequest.source(sourceBuilder);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u53c2\u6570   sourceBuilder------------------\uff1a" + JSON.toJSONString((Object)sourceBuilder));
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, ProfinanceReportVO.class));
            }
            page.setCurrent((long)pageNumber);
            page.setSize((long)pageSize);
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e.getMessage());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }

    public static void main(String[] args) {
        String ywDate = "2022-07-01,2022-07-31";
        List<String> dateList = Arrays.asList(ywDate.split(","));
        for (String s : dateList) {
            System.out.println(s);
        }
    }

    @RequestMapping(value={"queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleDetailVO> queryDetailRecord(Long contractId, Long supplierId, Long projectId) {
        SettleDetailVO settleDetailVO = new SettleDetailVO();
        if (contractId != null) {
            List<SettlePoolVO> settlePoolVOS = this.esService.queryDetailRecord(contractId);
            for (int i = 0; i < settlePoolVOS.size(); ++i) {
                if (!"\u52b3\u52a1\u5206\u5305\u6708\u5ea6\u7ed3\u7b97".equals(settlePoolVOS.get(i).getSettleSourceTypeName()) && !"\u4e13\u4e1a\u5206\u5305\u6708\u5ea6\u7ed3\u7b97".equals(settlePoolVOS.get(i).getSettleSourceTypeName())) continue;
                settlePoolVOS.remove(i);
            }
            settleDetailVO.setSettlePoolVOList(settlePoolVOS);
            List<PaymentApplyVO> paymentApplyVOS = this.esService.queryDetailRecord1(contractId);
            List<PaymentApplyVO> applyVOList = this.esService.queryApplyTaxMny(contractId);
            paymentApplyVOS.addAll(applyVOList);
            settleDetailVO.setPaymentApplyVOList(paymentApplyVOS);
        } else if (supplierId != null && projectId != null) {
            List<SettlePoolVO> settlePoolVOS = this.esService.queryDetailRecordNoContract(projectId, supplierId);
            for (int i = 0; i < settlePoolVOS.size(); ++i) {
                if (!"\u52b3\u52a1\u5206\u5305\u6708\u5ea6\u7ed3\u7b97".equals(settlePoolVOS.get(i).getSettleSourceTypeName()) && !"\u4e13\u4e1a\u5206\u5305\u6708\u5ea6\u7ed3\u7b97".equals(settlePoolVOS.get(i).getSettleSourceTypeName())) continue;
                settlePoolVOS.remove(i);
            }
            settleDetailVO.setSettlePoolVOList(settlePoolVOS);
            settleDetailVO.setPaymentApplyVOList(this.esService.queryDetailRecordNoContract1(projectId, supplierId));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)settleDetailVO);
    }

    @RequestMapping(value={"/queryTotalContract"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryTotalContract(@RequestBody QueryParam param) {
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        ArrayList commonOrgIds = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            Long orgId = InvocationInfoProxy.getOrgId();
            orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter("in", commonOrgIds));
            }
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        BigDecimal totalMny = BigDecimal.ZERO;
        BigDecimal totalAmountMny = BigDecimal.ZERO;
        for (Long orgId : commonOrgIds) {
            BigDecimal totalContract = this.esService.totalContract(tenantId, orgId);
            totalMny = totalContract == null ? totalMny.add(BigDecimal.ZERO) : totalMny.add(totalContract);
            BigDecimal AmountMny = this.esService.queryAmountMny(tenantId, orgId);
            if (AmountMny == null) {
                totalAmountMny = totalAmountMny.add(BigDecimal.ZERO);
                continue;
            }
            totalAmountMny = totalAmountMny.add(AmountMny);
        }
        JSONObject pageJson = new JSONObject();
        pageJson.put("totalContract", (Object)totalMny);
        pageJson.put("totalAmountMny", (Object)totalAmountMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)pageJson);
    }

    @RequestMapping(value={"employeePage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<EmployeeReportVO>> employeePage(@RequestBody QueryParam param) {
        Page page = new Page();
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        SearchRequest searchRequest = new SearchRequest(new String[]{"employeedeptcx"});
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            MatchQueryBuilder emName = QueryBuilders.matchQuery((String)"emName", (Object)param.getSearchText());
            MatchQueryBuilder orgName = QueryBuilders.matchQuery((String)"orgName", (Object)param.getSearchText());
            boolQuery.must((QueryBuilder)emName).must((QueryBuilder)orgName);
        }
        ArrayList<String> orgIdS = new ArrayList<String>();
        List orgVOS = (List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
        if (orgVOS != null && orgVOS.size() > 0) {
            for (OrgVO orgVO : orgVOS) {
                orgIdS.add(String.valueOf(orgVO.getId()));
            }
        }
        boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", orgIdS));
        for (Map.Entry entry : params.entrySet()) {
            String string = (String)entry.getKey();
            String value = this.getParamValue(params, string);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)string, (Object)value));
        }
        searchRequest.source().from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        searchRequest.source().size(pageSize);
        searchRequest.source().query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase((String)entry.getValue())) {
                    searchRequest.source().sort((String)entry.getKey(), SortOrder.ASC);
                    continue;
                }
                searchRequest.source().sort((String)entry.getKey(), SortOrder.DESC);
            }
        }
        searchRequest.source().query((QueryBuilder)boolQuery);
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                this.logger.info("----------------ES\u83b7\u53d6\u6570\u636e\u4e3a--------------\uff1a{}", (Object)sourceAsString);
                arrayList.add(JSON.parseObject((String)sourceAsString, EmployeeReportVO.class));
                for (EmployeeReportVO employeeReportVO : arrayList) {
                    CommonResponse userVO = this.userApi.findUserByUserId(employeeReportVO.getUserID());
                    if (userVO == null) continue;
                    try {
                        UserVO userVOData = (UserVO)userVO.getData();
                        if (userVOData == null) continue;
                        String userCode = userVOData.getUserCode();
                        userCode = userCode + ",999912310000";
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        employeeReportVO.setUrl(url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                page.setCurrent((long)pageNumber);
                page.setSize((long)pageSize);
                page.setRecords(arrayList);
                page.setTotal(hits.getTotalHits().value);
            }
        }
        catch (IOException iOException) {
            this.logger.error(iOException.getMessage());
            throw new BusinessException("\u6839\u636e paramMap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + iOException.getMessage());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

