/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputvalcount.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.mapper.MonthlyStatisticsMapper;
import com.ejianc.business.outputvalcount.service.IXmjdmxService;
import com.ejianc.business.outputvalcount.service.IXmyxglService;
import com.ejianc.business.outputvalcount.vo.OutputValDTO;
import com.ejianc.business.outputvalcount.vo.OutputValueVO;
import com.ejianc.business.outputvalcount.vo.ProjectDetailDTO;
import com.ejianc.business.outputvalcount.vo.XmyxglVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/outputValue/"})
public class OutputValueApi {
    @Autowired
    private MonthlyStatisticsMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IXmyxglService service;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IXmjdmxService xmjdmxService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"getSumByProjectId"}, method={RequestMethod.GET})
    CommonResponse<OutputValueVO> getSumByProjectId(@RequestParam(value="projectId") Long projectId) {
        String name = "";
        List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getMonthlyStatistics(projectId);
        BigDecimal sum = new BigDecimal(0);
        for (MonthlyStatisticsEntity entity : monthlyStatistics) {
            name = entity.getProjectName();
            if (entity.getBillState() != 1 && entity.getBillState() != 3) continue;
            sum = sum.add(entity.getBywccz());
        }
        OutputValueVO outputValueVO = new OutputValueVO();
        outputValueVO.setProjectName(name);
        outputValueVO.setProjectId(projectId);
        outputValueVO.setSum(sum);
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)outputValueVO);
    }

    @RequestMapping(value={"getInfoByProjectId"}, method={RequestMethod.GET})
    CommonResponse<List<XmyxglVO>> getInfoByProjectId(@RequestParam(value="projectId") Long projectId, @RequestParam(value="num") Integer num) {
        List respData = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(projectId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        respData.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            }
        });
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.setPageSize(num.intValue());
        queryParam.setPageIndex(1);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        queryParam.getParams().put("billState", new Parameter("in", billStates));
        queryParam.getParams().put("syxs", new Parameter("eq", (Object)2));
        IPage xmyxglEntityIPage = this.service.queryPage(queryParam, false);
        List xmyxglVOS = BeanMapper.mapList((Iterable)xmyxglEntityIPage.getRecords(), XmyxglVO.class);
        for (XmyxglVO vo : xmyxglVOS) {
            List data;
            CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(vo.getId(), "ZZYJ202205050002", "add", "");
            if (listCommonResponse.getCode() != 0 || (data = (List)listCommonResponse.getData()).size() <= 0) continue;
            String truePath = ((AttachmentVO)data.get(0)).getTruePath();
            int i = truePath.lastIndexOf(".");
            String substring = truePath.substring(0, i) + "_500x500" + truePath.substring(i);
            vo.setTruePath(substring);
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)xmyxglVOS);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"getSumByOrgId"}, method={RequestMethod.GET})
    CommonResponse<OutputValueVO> getSumByOrgId(@RequestParam(value="orgId") Long orgId) {
        List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getMonthlyStatisticsByDeptId(orgId);
        BigDecimal sum = new BigDecimal(0);
        for (MonthlyStatisticsEntity entity : monthlyStatistics) {
            if (entity.getBillState() != 1 && entity.getBillState() != 3) continue;
            sum = sum.add(entity.getBywccz());
        }
        OutputValueVO outputValueVO = new OutputValueVO();
        CommonResponse oneById = this.iOrgApi.getOneById(orgId);
        if (oneById.getCode() == 0) {
            OrgVO data = (OrgVO)oneById.getData();
            outputValueVO.setProjectName(data.getName());
        }
        outputValueVO.setProjectId(orgId);
        outputValueVO.setSum(sum);
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)outputValueVO);
    }

    @RequestMapping(value={"getSumByOrgIdUnder"}, method={RequestMethod.GET})
    CommonResponse<BigDecimal> getSumByOrgIdUnder(@RequestParam(value="orgId") Long orgId, @RequestParam(value="year") Integer year) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("projectDepartmentId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (!year.equals(0)) {
            param.getParams().put("statDate", new Parameter("between", (Object)(year + "-1-1," + year + "-12-31")));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getSumByOrgIdUnder(wrapper);
        BigDecimal sum = new BigDecimal(0);
        for (MonthlyStatisticsEntity entity : monthlyStatistics) {
            if (entity.getBillState() != 1 && entity.getBillState() != 3) continue;
            sum = sum.add(entity.getBywccz());
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)sum);
    }

    @RequestMapping(value={"getSumByOrgIds"}, method={RequestMethod.POST})
    CommonResponse<HashMap<Long, BigDecimal>> getSumByOrgIds(@RequestBody OutputValDTO dto) {
        if (dto.getOrgIds() == null) {
            return CommonResponse.error((String)"\u9879\u76eeid\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (dto.getYear() != null && !dto.getYear().equals(0)) {
            param.getParams().put("statDate", new Parameter("between", (Object)(dto.getYear() + "-1-1," + dto.getYear() + "-12-31")));
        }
        HashMap<Long, BigDecimal> hashMap = new HashMap<Long, BigDecimal>();
        for (Long orgId : dto.getOrgIds()) {
            param.getParams().put("projectDepartmentId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getSumByOrgIdUnder(wrapper);
            BigDecimal sum = new BigDecimal(0);
            for (MonthlyStatisticsEntity entity : monthlyStatistics) {
                if (entity.getBillState() != 1 && entity.getBillState() != 3) continue;
                sum = sum.add(entity.getBywccz());
            }
            hashMap.put(orgId, sum);
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", hashMap);
    }

    @RequestMapping(value={"getOutputValue"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ProjectDetailDTO>> getOutputValue(HttpServletRequest request) {
        String syncMode = request.getParameter("syncMode");
        String syncTime = null;
        if ("increment".equals(syncMode)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            syncTime = dateFormat.format(calendar.getTime()) + " 00:00:00";
            this.logger.info("syncTime\u4e3a\uff1a--{}", (Object)syncTime);
        }
        List<ProjectDetailDTO> supplierBankList = this.xmjdmxService.queryOutputValueBySyncTime(syncTime);
        return CommonResponse.success(supplierBankList);
    }
}

