package com.ejianc.business.appliances.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.appliances.bean.MeteringAllocationDetailEntity;
import com.ejianc.business.appliances.bean.MeteringAllocationEntity;
import com.ejianc.business.appliances.bean.MeteringRecordsEntity;
import com.ejianc.business.appliances.bean.MeteringReportEntity;
import com.ejianc.business.appliances.service.IMeteringAllocationDetailService;
import com.ejianc.business.appliances.service.IMeteringAllocationService;
import com.ejianc.business.appliances.service.IMeteringRecordsService;
import com.ejianc.business.appliances.service.IMeteringReportService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("meteringAllocation")
public class MeteringAllocationBpmServiceImpl implements ICommonBusinessService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMeteringAllocationService allocationService;

    @Autowired
    private IMeteringAllocationDetailService allocationDetailService;

    @Autowired
    private IMeteringReportService reportService;

    @Autowired
    private IMeteringRecordsService recordsService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        /**
         * 1.更改台账中使用状态
         * 2.推送更改记录表
         */
        MeteringAllocationEntity entity = allocationService.selectById(billId);
        //查找子表数据
        List<MeteringAllocationDetailEntity> detailEntities = allocationDetailService.list(Wrappers.<MeteringAllocationDetailEntity>lambdaQuery()
                .eq(MeteringAllocationDetailEntity::getDr, 0)
                .eq(MeteringAllocationDetailEntity::getAllocationId, entity.getId())
        );
        if (ListUtil.isNotEmpty(detailEntities)) {

            for (MeteringAllocationDetailEntity detailEntity : detailEntities) {

                MeteringRecordsEntity recordsEntity = new MeteringRecordsEntity();
                boolean update = false;
                if ("调入".equals(entity.getChangeType())) {
                    //更改使用状态
                    update = reportService.update(Wrappers.<MeteringReportEntity>lambdaUpdate()
                            .set(MeteringReportEntity::getUseStatus, 1)
                            .set(MeteringReportEntity::getProjectId, entity.getTransferInUnit())
                            .set(MeteringReportEntity::getProjectName, entity.getTransferInUnitName())
                            .set(MeteringReportEntity::getStartDate,detailEntity.getStartDate())
                            .eq(MeteringReportEntity::getId, detailEntity.getMeteringId())
                            .eq(MeteringReportEntity::getDr, 0)
                    );
                    recordsEntity.setUseStatus("1");
                } else {
                    //更改使用状态
                    update = reportService.update(Wrappers.<MeteringReportEntity>lambdaUpdate()
                            .set(MeteringReportEntity::getUseStatus, 2)
                            .set(MeteringReportEntity::getProjectId, entity.getTransferInUnit())
                            .set(MeteringReportEntity::getProjectName, entity.getTransferInUnitName())
                            .set(MeteringReportEntity::getStartDate,null)
                            .eq(MeteringReportEntity::getId, detailEntity.getMeteringId())
                            .eq(MeteringReportEntity::getDr, 0)
                    );
                    recordsEntity.setUseStatus("2");
                }

                if (update) {
                    logger.info("更新设备使用状态成功！");
                }

                //生成更改记录
                recordsEntity.setMeteringId(detailEntity.getMeteringId());
                recordsEntity.setMeteringCode(detailEntity.getMeteringCode());
                recordsEntity.setMeteringName(detailEntity.getMeteringName());
                recordsEntity.setMeteringModel(detailEntity.getMeteringModel());
                recordsEntity.setChangeDate(entity.getDate());

                recordsEntity.setProjectId(entity.getTransferInUnit());
                recordsEntity.setProjectName(entity.getTransferInUnitName());

                recordsEntity.setSourceId(entity.getId());
                recordsEntity.setSourceCode(entity.getBillCode());
                recordsEntity.setSourceType("MeteringAllocation");
                recordsEntity.setChangeType(entity.getChangeType());
                recordsService.saveOrUpdate(recordsEntity);

                logger.info("推送变更记录表成功");
            }

        } else {
            logger.info("子表数据为空！");
            return CommonResponse.error("子表数据为空！");
        }

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
