package com.ejianc.business.user.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.user.bean.UserGoOutEntity;
import com.ejianc.business.user.service.IUserGoOutService;
import com.ejianc.business.user.vo.UserGoOutVO;

/**
 * 员工去向牌
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("userGoOut")
public class UserGoOutController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IUserGoOutService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UserGoOutVO> saveOrUpdate(@RequestBody UserGoOutVO saveOrUpdateVO) {
    	UserGoOutEntity entity = BeanMapper.map(saveOrUpdateVO, UserGoOutEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	UserGoOutVO vo = BeanMapper.map(entity, UserGoOutVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UserGoOutVO> queryDetail(Long id) {
    	UserGoOutEntity entity = service.selectById(id);
    	UserGoOutVO vo = BeanMapper.map(entity, UserGoOutVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UserGoOutVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (UserGoOutVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(UserGoOutVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UserGoOutVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("userName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("outReason");


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /**
         * 处理行程状态筛选
         */

        if (param.getParams().containsKey("type1")){
            String type1=(String)param.getParams().get("type1").getValue();
            param.getParams().remove("type1");

            //设置要获取的时间类型
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            //获取String类型的时间
            String createdate = sdf.format(new Date());

            switch (type1){
                case "行程未生效":
                    param.getParams().put("billState", new Parameter(QueryParam.NOT_IN,Arrays.asList(1,3)));
                    break;
                case "行程取消":
                    param.getParams().put("billState", new Parameter(QueryParam.IN,Arrays.asList(1,3)));
                    param.getParams().put("type", new Parameter(QueryParam.NE, "0"));
                    break;
                case "待外出":
                    param.getParams().put("billState", new Parameter(QueryParam.IN,Arrays.asList(1,3)));
                    param.getParams().put("type", new Parameter(QueryParam.EQ, "0"));
                    param.getParams().put("startTime", new Parameter(QueryParam.GE, createdate));
                    break;
                case "外出中":
                    param.getParams().put("billState", new Parameter(QueryParam.IN,Arrays.asList(1,3)));
                    param.getParams().put("type", new Parameter(QueryParam.EQ, "0"));
                    param.getParams().put("startTime", new Parameter(QueryParam.LE, createdate));
                    param.getParams().put("endDate", new Parameter(QueryParam.GE, createdate));
                    break;
                case "已返回":
                    param.getParams().put("billState", new Parameter(QueryParam.IN,Arrays.asList(1,3)));
                    param.getParams().put("type", new Parameter(QueryParam.EQ, "0"));
                    param.getParams().put("endDate", new Parameter(QueryParam.LE, createdate));
                    break;
            }

        }
        //经营管理层可以看到所有数据，非经营管理层只能看到非自己部门的数据
        UserContext userContextCache =sessionManager.getUserContext();
        if (userContextCache.getDdId() == null) {//部门为空只能看到自己的
            param.getParams().put("userId", new Parameter(QueryParam.EQ, userContextCache.getUserId()));
        }else {
            if (!userContextCache.getDeptId().equals(1502571152969568257L)) {//部门不为空且不是经营管理层，只能看到自己部门的
                param.getParams().put("unitId", new Parameter(QueryParam.EQ, userContextCache.getDeptId()));
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
//        UserContext userContextCache =sessionManager.getUserContext();
//        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
//        String authOrgIds = userContextCache.getAuthOrgIds();
//        List<OrgVO> orgVOList = null;
//        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
//        }else {//pc端查询
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        //普通组织 id
//        List<Long> commonOrgIds = new ArrayList<>();
//        //项目部 id
//        List<Long> departmentIds = new ArrayList<>();
//        orgVOList.stream().forEach(org -> {
//            if(5 == org.getOrgType()) {
//                //项目部
//                departmentIds.add(org.getId());
//            } else {
//                //普通组织
//                commonOrgIds.add(org.getId());
//            }
//        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
//        }

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<UserGoOutEntity> page = service.queryPage(param,false);
        IPage<UserGoOutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<UserGoOutVO> userGoOutVOS = BeanMapper.mapList(page.getRecords(), UserGoOutVO.class);
        long time = new Date().getTime();
        for (UserGoOutVO userGoOutVO : userGoOutVOS) {
                if (userGoOutVO.getBillState() == 1 || userGoOutVO.getBillState() == 3){

                    if ("0".equals(userGoOutVO.getType())){//是否取消行程 0否
                        Long startTime = userGoOutVO.getStartTime().getTime();
                        Long endDate = userGoOutVO.getEndDate().getTime();
                        if (time < startTime){
                            userGoOutVO.setType1( "待外出");
                        }else if (time >= startTime && time <= endDate){
                            userGoOutVO.setType1("外出中");
                        }else {
                            userGoOutVO.setType1("已返回");
                        }

                    }else {
                        userGoOutVO.setType1("行程取消");
                    }
                }else {
                    userGoOutVO.setType1("行程未生效");
                }
        }
  		pageData.setRecords(userGoOutVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<UserGoOutEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("UserGoOut-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refUserGoOutData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UserGoOutVO>> refUserGoOutData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<UserGoOutEntity> page = service.queryPage(param,false);
        IPage<UserGoOutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UserGoOutVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
