package com.ejianc.business.appliances.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.appliances.bean.*;
import com.ejianc.business.appliances.service.*;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("meteringMaintainAppraisal") 
public class MeteringMaintainAppraisalBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IMeteringMaintainAppraisalService maintainAppraisalService;

	@Autowired
	private IMeteringMaintainAppraisalDetailService maintainAppraisalDetailService;

	@Autowired
	private IMeteringReportService reportService;

	@Autowired
	private IMeteringRecordsService recordsService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		/**
		 * 1.更改台账中设备状态
		 * 2.推送更改记录表
		 */
		MeteringMaintainAppraisalEntity entity = maintainAppraisalService.selectById(billId);
		//查找子表数据
		List<MeteringMaintainAppraisalDetailEntity> detailEntities = maintainAppraisalDetailService.list(Wrappers.<MeteringMaintainAppraisalDetailEntity>lambdaQuery()
				.eq(MeteringMaintainAppraisalDetailEntity::getDr, 0)
				.eq(MeteringMaintainAppraisalDetailEntity::getMaintainId, entity.getId())
		);
		if(ListUtil.isNotEmpty(detailEntities)){

			for (MeteringMaintainAppraisalDetailEntity detailEntity : detailEntities) {
				MeteringRecordsEntity recordsEntity = new MeteringRecordsEntity();
				boolean update = false;
				//更改设备状态
				if("维保".equals(entity.getChangeType())){
					update = reportService.update(Wrappers.<MeteringReportEntity>lambdaUpdate()
							.set(MeteringReportEntity::getMeteringStatus, detailEntity.getMeteringStatus())
							.set(MeteringReportEntity::getMaintenanceDate,detailEntity.getMaintenanceDate())
							.set(MeteringReportEntity::getAppraisalReportCode,entity.getReportCode())
							.eq(MeteringReportEntity::getId, detailEntity.getMeteringId())
							.eq(MeteringReportEntity::getDr, 0)
					);
				} else {
					update = reportService.update(Wrappers.<MeteringReportEntity>lambdaUpdate()
							.set(MeteringReportEntity::getMeteringStatus, detailEntity.getMeteringStatus())
							.set(MeteringReportEntity::getAppraisalDate,detailEntity.getMaintenanceDate())
							.set(MeteringReportEntity::getAppraisalReportCode,entity.getReportCode())
							.eq(MeteringReportEntity::getId, detailEntity.getMeteringId())
							.eq(MeteringReportEntity::getDr, 0)
					);
				}

				if(update){
					logger.info("更新设备状态成功！");
				}
				//生成更改记录


				recordsEntity.setMeteringId(detailEntity.getMeteringId());
				recordsEntity.setMeteringCode(detailEntity.getMeteringCode());
				recordsEntity.setMeteringName(detailEntity.getMeteringName());
				recordsEntity.setMeteringModel(detailEntity.getMeteringModel());
				recordsEntity.setChangeDate(entity.getDate());

				//recordsEntity.setUseStatus(1);
				recordsEntity.setMeteringStatus(detailEntity.getMeteringStatus());

				recordsEntity.setSourceId(entity.getId());
				recordsEntity.setSourceCode(entity.getBillCode());
				recordsEntity.setSourceType("MeteringMaintainAppraisal");
				recordsEntity.setChangeType(entity.getChangeType());
				recordsService.saveOrUpdate(recordsEntity);

				logger.info("推送变更记录表成功");
			}

		} else {
			logger.info("子表数据为空！");
			return CommonResponse.error("子表数据为空！");
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
