package com.ejianc.business.appliances.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.appliances.bean.MeteringRecordsEntity;
import com.ejianc.business.appliances.bean.MeteringRegisterDetailEntity;
import com.ejianc.business.appliances.bean.MeteringRegisterEntity;
import com.ejianc.business.appliances.bean.MeteringReportEntity;
import com.ejianc.business.appliances.service.IMeteringRecordsService;
import com.ejianc.business.appliances.service.IMeteringRegisterDetailService;
import com.ejianc.business.appliances.service.IMeteringRegisterService;
import com.ejianc.business.appliances.service.IMeteringReportService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;

@Service("meteringRegister") 
public class MeteringRegisterBpmServiceImpl implements ICommonBusinessService {


	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IMeteringReportService reportService;
	@Autowired
	private IMeteringRegisterService registerService;
	@Autowired
	private IMeteringRegisterDetailService registerDetailService;
	@Autowired
	private IMeteringRecordsService recordsService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		/**
		 * 将数据推送到台账中，并生成记录
		 */
		//推送台账
		MeteringRegisterEntity registerEntity = registerService.selectById(billId);
		//查询子表数据
		List<MeteringRegisterDetailEntity> detailEntities = registerDetailService.list(Wrappers.<MeteringRegisterDetailEntity>lambdaQuery()
				.eq(MeteringRegisterDetailEntity::getRegisterId, billId)
		);
		if(ListUtil.isNotEmpty(detailEntities)){
			for (MeteringRegisterDetailEntity detailEntity : detailEntities) {
				MeteringRecordsEntity recordsEntity = new MeteringRecordsEntity();

				MeteringReportEntity reportEntity = BeanMapper.map(detailEntity, MeteringReportEntity.class);
				reportEntity.setId(null);
				reportEntity.setBillState(null);
				reportEntity.setCreateTime(new Date());
				reportEntity.setBillCode(null);
				reportEntity.setUpdateUserName(null);
				reportEntity.setUpdateTime(null);
				reportEntity.setUpdateUserCode(null);
				reportEntity.setSourceId(billId);//来源id
				//主表内容
				reportEntity.setProjectId(registerEntity.getProjectId());
				reportEntity.setProjectName(registerEntity.getProjectName());
				reportEntity.setPatrolGroup(registerEntity.getPatrolGroup());
				reportEntity.setPatrolGroupId(registerEntity.getPatrolGroupId());
				reportEntity.setTechnologyId(registerEntity.getTechnologyId());
				reportEntity.setTechnologyName(registerEntity.getTechnologyName());
				reportEntity.setEngineeringType(registerEntity.getEngineeringType());
				reportEntity.setEngineeringTypeId(registerEntity.getEngineeringTypeId());
				reportEntity.setStructureType(registerEntity.getStructureType());
				reportEntity.setStructureTypeName(registerEntity.getStructureTypeName());
				reportEntity.setTestersId(registerEntity.getTestersId());
				reportEntity.setTestersName(registerEntity.getTestersName());
				reportEntity.setRemark(registerEntity.getRemark());
				reportEntity.setOrgId(registerEntity.getOrgId());
				reportEntity.setOrgName(registerEntity.getOrgName());

				reportService.saveOrUpdate(reportEntity);
				logger.info("推送台账成功--------------------------------{}",reportEntity);

				//生成更改记录
				recordsEntity.setMeteringId(reportEntity.getId());
				recordsEntity.setMeteringCode(detailEntity.getMeteringCode());
				recordsEntity.setMeteringName(detailEntity.getMeteringName());
				recordsEntity.setMeteringModel(detailEntity.getMeteringModel());
				recordsEntity.setChangeDate(registerEntity.getStartDate());

				//recordsEntity.setUseStatus(1);
				recordsEntity.setMeteringStatus(detailEntity.getMeteringStatus());

				recordsEntity.setSourceId(registerEntity.getId());
				recordsEntity.setSourceCode(registerEntity.getBillCode());
				recordsEntity.setSourceType("MeteringRegister");
				recordsEntity.setChangeType("登记");
				recordsService.saveOrUpdate(recordsEntity);

				logger.info("推送变更记录表成功");

			}
			return CommonResponse.success();

		}
		logger.info("提交失败，子表数据为空");
		return CommonResponse.error("提交失败，子表数据为空！");

		//TODO 生成记录
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
