package com.ejianc.business.outputvalcount.service.impl;

import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterCommunicationVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterDisputeVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterExamineVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.outputvalcount.mapper.ProjectInfoRegisterMapper;
import com.ejianc.business.outputvalcount.bean.ProjectInfoRegisterEntity;
import com.ejianc.business.outputvalcount.service.IProjectInfoRegisterService;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目相关方信息每日填报
 * 
 * @author generator
 * 
 */
@Service("projectInfoRegisterService")
public class ProjectInfoRegisterServiceImpl extends BaseServiceImpl<ProjectInfoRegisterMapper, ProjectInfoRegisterEntity> implements IProjectInfoRegisterService{

    @Autowired
    private ProjectInfoRegisterMapper mapper;
    @Override
    public List<Long> getDesktopZhuIds(Long projectId,String type) {

        List<ProjectInfoRegisterVO> registerVOS = mapper.queryProjectInfoRegisterList(projectId);
        List<Long> ids = registerVOS.stream().map(ProjectInfoRegisterVO::getId).collect(Collectors.toList());
        //上级单位检查
        List<ProjectInfoRegisterExamineVO> examineVOS = mapper.queryProjectInfoExamineList(ids);
        //合同纠纷异常
        List<ProjectInfoRegisterDisputeVO> disputeVOS = mapper.queryProjectInfoDisputeList(ids);
        //其他协同异常
        List<ProjectInfoRegisterCommunicationVO> communicationVOS = mapper.queryProjectInfoCommunicationList(ids);

        List<Long> examineVOSZhuIds = examineVOS.stream().filter(s -> "1".equals(s.getExamineState())).map(ProjectInfoRegisterExamineVO::getZhuId).collect(Collectors.toList());
        List<Long> disputeVOSZhuIds = disputeVOS.stream().map(ProjectInfoRegisterDisputeVO::getZhuId).collect(Collectors.toList());
        List<Long> communicationVOSZhuIds = communicationVOS.stream().map(ProjectInfoRegisterCommunicationVO::getZhuId).collect(Collectors.toList());

        List<Long> zhuIds = new ArrayList<>();
        zhuIds.addAll(examineVOSZhuIds);
        zhuIds.addAll(disputeVOSZhuIds);
        zhuIds.addAll(communicationVOSZhuIds);
        return zhuIds;
    }
}
