package com.ejianc.business.outputvalcount.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.outputvalcount.bean.ProjectInfoRegisterEntity;

import java.util.List;
import java.util.Set;

/**
 * 项目相关方信息每日填报
 * 
 * @author generator
 * 
 */
public interface IProjectInfoRegisterService extends IBaseService<ProjectInfoRegisterEntity> {
    /**
     * 项目信息门户专用接口，根据projectId查询主表id
     *      1.下发整改通知单的
     *      2.存在事件的
     * @param projectId
     * @return
     */
    Set<Long> getDesktopZhuIds(Long projectId, String type);
    /**
     * 根据id批量分页查询
     */
    List<ProjectInfoRegisterVO> queryListPage(Page<ProjectInfoRegisterVO> page, QueryWrapper wrapper,Set<Long> ids);

}
