package com.ejianc.business.outputvalcount.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputvalcount.vo.*;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.outputvalcount.bean.ProjectInfoRegisterEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * 项目相关方信息每日填报
 * 
 * @author generator
 * 
 */
@Mapper
public interface ProjectInfoRegisterMapper extends BaseCrudMapper<ProjectInfoRegisterEntity> {
    @Select("SELECT id,create_date,COUNT(*) count FROM `t_project_info_register`\n" +
            "where bill_state in (1,3,0)\n" +
            "and dr = 0\n" +
            "GROUP BY create_date\n" +
            "ORDER BY create_date desc")
    List<ProjectInfoRegisterVO> getProduction(Page<ProjectInfoRegisterVO> page);


    @Select("select e1.*,r3.project_name as project_name1 from t_project_info_register_examine e1\n" +
            "LEFT JOIN t_project_info_register r3\n" +
            "on e1.zhu_id = r3.id\n" +
            "where e1.dr = 0\n" +
            "and e1.zhu_id in \n" +
            "(select id from `t_project_info_register` r1\n" +
            "where r1.create_date in \n" +
            "(SELECT r2.create_date FROM `t_project_info_register` r2\n" +
            "where r2.id = #{id}) )")
    List<ProjectInfoRegisterExamineVO> getExamine(Long id);



    @Select("select e1.*,r3.project_name from t_project_info_register_dispute e1\n" +
            "LEFT JOIN t_project_info_register r3\n" +
            "on e1.zhu_id = r3.id\n" +
            "where e1.dr = 0\n" +
            "and e1.zhu_id in \n" +
            "(select id from `t_project_info_register` r1\n" +
            "where r1.create_date in \n" +
            "(SELECT r2.create_date FROM `t_project_info_register` r2\n" +
            "where r2.id = #{id}) )")
    List<ProjectInfoRegisterDisputeVO> getDispute(Long id);



    @Select("select e1.*,r3.project_name from t_project_info_register_communication e1\n" +
            "LEFT JOIN t_project_info_register r3\n" +
            "on e1.zhu_id = r3.id\n" +
            "where e1.dr = 0\n" +
            "and e1.zhu_id in \n" +
            "(select id from `t_project_info_register` r1\n" +
            "where r1.create_date in \n" +
            "(SELECT r2.create_date FROM `t_project_info_register` r2\n" +
            "where r2.id = #{id}) )")
    List<ProjectInfoRegisterCommunicationVO> getCommunication(Long id);


    List<ProjectInfoRegisterVO> getProjectNum(Page<ProjectInfoRegisterVO> page);

    /**
     * 根据项目id查询相关方每日信息填报
     * @param projectId
     * @return
     */
    @Select("SELECT * FROM `zzyj-outputvalcount`.`t_project_info_register` " +
            "where dr = 0 and project_id = #{projectId}")
    List<ProjectInfoRegisterVO> queryProjectInfoRegisterList(Long projectId);
    /**
     * 根据项目id查询相关方每日信息填报主表id查询子表，上级单位检查
     * @param ids
     * @return
     */
    List<ProjectInfoRegisterExamineVO> queryProjectInfoExamineList(@Param("ids") List<Long> ids);
    /**
     * 根据项目id查询相关方每日信息填报主表id查询子表，合同纠纷异常
     * @param ids
     * @return
     */
    List<ProjectInfoRegisterDisputeVO> queryProjectInfoDisputeList(@Param("ids") List<Long> ids);
    /**
     * 根据项目id查询相关方每日信息填报主表id查询子表，其他协同异常
     * @param ids
     * @return
     */
    List<ProjectInfoRegisterCommunicationVO> queryProjectInfoCommunicationList(@Param("ids") List<Long> ids);

    /**
     * 根据id分页查询
     * @param page
     * @param wrapper
     * @return
     */
    List<ProjectInfoRegisterVO> queryListPage(Page<ProjectInfoRegisterVO> page, @Param(Constants.WRAPPER)QueryWrapper wrapper,@Param("ids") List<Long> ids);


}
