/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.worklog.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.worklog.bean.PersonLogEntity;
import com.ejianc.business.worklog.service.IPersonLogService;
import com.ejianc.business.worklog.vo.DepartmentLogDetailVO;
import com.ejianc.business.worklog.vo.PersonLogVO;
import com.ejianc.business.worklog.vo.WorkTypeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"personLog"})
public class PersonLogController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPersonLogService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PersonLogVO> saveOrUpdate(@RequestBody PersonLogVO saveOrUpdateVO) {
        PersonLogEntity entity = (PersonLogEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PersonLogEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PersonLogVO vo = (PersonLogVO)BeanMapper.map((Object)((Object)entity), PersonLogVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PersonLogVO> queryDetail(Long id) {
        PersonLogEntity entity = (PersonLogEntity)((Object)this.service.selectById(id));
        PersonLogVO vo = (PersonLogVO)BeanMapper.map((Object)((Object)entity), PersonLogVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PersonLogVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PersonLogVO personLogVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PersonLogVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PersonLogVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PersonLog-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPersonLogTreeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DepartmentLogDetailVO>> refPersonLogTreeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText, String relyCondition) {
        Long departmentId = null;
        Date workDate = null;
        String logType = null;
        Long workTypeId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject con = JSONObject.parseObject((String)condition);
            if (null != con.get((Object)"departmentId")) {
                departmentId = con.getLong("departmentId");
            }
            if (null != con.get((Object)"workDate")) {
                workDate = con.getDate("workDate");
            }
            if (null != con.get((Object)"logType")) {
                logType = con.getString("logType");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            workTypeId = Long.parseLong(relyCondition.split("=")[1]);
        }
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        Page<DepartmentLogDetailVO> pageData = this.service.getPersonLog((Page<DepartmentLogDetailVO>)page, departmentId, workDate, logType, workTypeId);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/refPersonLogTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refPersonLogTree(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText) {
        List<WorkTypeVO> dataList = null;
        try {
            JSONObject con;
            Long departmentId;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
            }
            if (StringUtils.isNotBlank((CharSequence)condition) && null != (departmentId = (con = JSONObject.parseObject((String)condition)).getLong("departmentId"))) {
                params.put("departmentId", departmentId);
            }
            dataList = this.service.queryWorkTypeTree(params);
            List maps = BeanMapper.mapList(dataList, Map.class);
            for (Map map : maps) {
                String name = map.get("workTypeName").toString();
                map.remove("workTypeName");
                map.put("name", name);
                String parentId = map.get("lastTypeId") != null ? map.get("lastTypeId").toString() : "";
                map.remove("lastTypeId");
                map.put("parentId", parentId);
            }
            this.logger.info("\u8fd4\u56de\u53c2\u7167\u6570\u636e\u4e3a{}", (Object)JSON.toJSONString((Object)maps));
            return ResultAsTree.createTreeData((List)maps);
        }
        catch (Exception e) {
            this.logger.info("\u9519\u8bef\u539f\u56e0\u4e3a{}", (Object)JSON.toJSONString((Object)e));
            return null;
        }
    }
}

