package com.ejianc.business.outputvalcount.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterCommunicationVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterDisputeVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterExamineVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.outputvalcount.mapper.ProjectInfoRegisterMapper;
import com.ejianc.business.outputvalcount.bean.ProjectInfoRegisterEntity;
import com.ejianc.business.outputvalcount.service.IProjectInfoRegisterService;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 项目相关方信息每日填报
 * 
 * @author generator
 * 
 */
@Service("projectInfoRegisterService")
public class ProjectInfoRegisterServiceImpl extends BaseServiceImpl<ProjectInfoRegisterMapper, ProjectInfoRegisterEntity> implements IProjectInfoRegisterService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ProjectInfoRegisterMapper mapper;

    @Override
    public List<Long> getDesktopZhuIds(Long projectId,String type,String checkStatus) {

        List<ProjectInfoRegisterVO> registerVOS = mapper.queryProjectInfoRegisterList(projectId,checkStatus);
        List<Long> ids = registerVOS.stream().map(ProjectInfoRegisterVO::getId).collect(Collectors.toList());
        //上级单位检查
        List<ProjectInfoRegisterExamineVO> examineVOS = mapper.queryProjectInfoExamineList(ids);
        //合同纠纷异常
        List<ProjectInfoRegisterDisputeVO> disputeVOS = mapper.queryProjectInfoDisputeList(ids);
        //其他协同异常
        List<ProjectInfoRegisterCommunicationVO> communicationVOS = mapper.queryProjectInfoCommunicationList(ids);

        List<Long> examineVOSZhuIds = examineVOS.stream().filter(s -> "1".equals(s.getExamineState())).map(ProjectInfoRegisterExamineVO::getZhuId).collect(Collectors.toList());
        List<Long> examineVOSAllZhuIds = examineVOS.stream().map(ProjectInfoRegisterExamineVO::getZhuId).collect(Collectors.toList());
        List<Long> disputeVOSZhuIds = disputeVOS.stream().map(ProjectInfoRegisterDisputeVO::getZhuId).collect(Collectors.toList());
        List<Long> communicationVOSZhuIds = communicationVOS.stream().map(ProjectInfoRegisterCommunicationVO::getZhuId).collect(Collectors.toList());

        List<Long> zhuIds = new ArrayList<>();
        if("examineState".equals(type)){
            logger.info("下发整改通知单单据{}", JSON.toJSONString(examineVOSZhuIds));
            zhuIds.addAll(examineVOSZhuIds);
        } else {
            zhuIds.addAll(examineVOSAllZhuIds);
            logger.info("下发整改通知单单据{}", JSON.toJSONString(examineVOSAllZhuIds));
            zhuIds.addAll(disputeVOSZhuIds);
            logger.info("合同纠纷异常单据{}", JSON.toJSONString(disputeVOSZhuIds));
            zhuIds.addAll(communicationVOSZhuIds);
            logger.info("其他协同异常单据{}", JSON.toJSONString(communicationVOSZhuIds));

        }

        return zhuIds;
    }

    @Override
    public List<ProjectInfoRegisterVO> queryListPage(Page<ProjectInfoRegisterVO> page, QueryWrapper wrapper,List<Long> ids) {
        return mapper.queryListPage(page,wrapper,ids);
    }
}
